#include "FileHolder.h"

FileHolder::FileHolder()
{
	hfile = 0;
}

FileHolder::~FileHolder()
{
	close();
}

bool FileHolder::checkError()
{
	if (hfile == INVALID_HANDLE_VALUE)
	{
		hfile = 0;
		return false;
	}

	return true;
}

bool FileHolder::create(char *filename)
{
	close();
	hfile = CreateFile(filename, FILE_WRITE_DATA, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	return checkError();
}

void FileHolder::close()
{
	if (hfile)
	{
		CloseHandle(hfile);
		hfile = 0;
	}
}

bool FileHolder::openToRead(char *filename)
{
	close();
	hfile = CreateFile(filename, FILE_READ_DATA, 0, NULL, OPEN_EXISTING, 0, NULL);
	return checkError();
}

bool FileHolder::openToWrite(char *filename)
{
	close();
	hfile = CreateFile(filename, FILE_WRITE_DATA, 0, NULL, OPEN_EXISTING, 0, NULL);
	return checkError();
}

void FileHolder::seek(DWORD pos)
{
	SetFilePointer(hfile, pos, NULL, FILE_BEGIN);
}

DWORD FileHolder::getFileSize()
{
	return GetFileSize(hfile, NULL);
}

void FileHolder::readBuffer(BYTE *data, DWORD amount)
{
	DWORD read_bytes;
	ReadFile(hfile, data, amount, &read_bytes, NULL);
}

BYTE FileHolder::readByte()
{
	DWORD read_bytes;
	BYTE data;
	ReadFile(hfile, &data, 1, &read_bytes, NULL);
	return data;
}

WORD FileHolder::readWord()
{
	DWORD read_bytes;
	WORD data;
	ReadFile(hfile, &data, 2, &read_bytes, NULL);
	return data;
}

DWORD FileHolder::readDword()
{
	DWORD read_bytes;
	DWORD data;
	ReadFile(hfile, &data, 4, &read_bytes, NULL);
	return data;
}

int FileHolder::readInt()
{
	DWORD read_bytes;
	int data;
	ReadFile(hfile, &data, 4, &read_bytes, NULL);
	return data;
}

float FileHolder::readFloat()
{
	DWORD read_bytes;
	float data;
	ReadFile(hfile, &data, 4, &read_bytes, NULL);
	return data;
}

void FileHolder::writeBuffer(BYTE *data, DWORD amount)
{
	DWORD write_bytes;
	WriteFile(hfile, data, amount, &write_bytes, NULL);
}

void FileHolder::writeByte(BYTE data)
{
	DWORD write_bytes;
	WriteFile(hfile, &data, 1, &write_bytes, NULL);
}

void FileHolder::writeWord(WORD data)
{
	DWORD write_bytes;
	WriteFile(hfile, &data, 2, &write_bytes, NULL);
}

void FileHolder::writeDword(DWORD data)
{
	DWORD write_bytes;
	WriteFile(hfile, &data, 4, &write_bytes, NULL);
}

void FileHolder::writeInt(int data)
{
	DWORD write_bytes;
	WriteFile(hfile, &data, 4, &write_bytes, NULL);
}

void FileHolder::writeFloat(float data)
{
	DWORD write_bytes;
	WriteFile(hfile, &data, 4, &write_bytes, NULL);
}

bool FileHolder::isFileExisting(char *filename)
{
	HANDLE check_hfile = CreateFile(filename, FILE_READ_DATA, 0, NULL, OPEN_EXISTING, 0, NULL);
	if (check_hfile == INVALID_HANDLE_VALUE)
		return false;
	else
	{
		CloseHandle(check_hfile);
		return true;
	}
}