#pragma once

#include <windows.h>

class FileHolder
{
public:
	FileHolder();
	~FileHolder();

	bool	openToRead(char *filename);
	bool	openToWrite(char *filename);
	bool	create(char *filename);
	void	seek(DWORD pos);
	DWORD	getFileSize();
	void	close();

	static bool	isFileExisting(char *filename);

	void	writeBuffer(BYTE *data, DWORD amount);
	void	writeByte(BYTE data);
	void	writeWord(WORD data);
	void	writeDword(DWORD data);
	void	writeInt(int data);
	void	writeFloat(float data);

	void	readBuffer(BYTE *data, DWORD amount);
	BYTE	readByte();
	WORD	readWord();
	DWORD	readDword();
	int		readInt();
	float	readFloat();

private:
	HANDLE	hfile;

	bool	checkError();
};