#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>

#include "aTex2D.h"
#include "ImageAnim.h"
#include "timecontrol.h"
#include "sgoScene/sgoScene.h"
#include "camera.h"
#include "cameras.h"
#include "active_camera.h"
#include "fmod.h"
#include "flash.h"

extern void SteerCamera(float ms);
extern void ScreenTo2D();
extern void ScreenTo3D();
extern void showFPS(float ms);

extern void progressGo();
extern void progressReady();

extern char *program_directory;

extern DWORD scr_cx_res;
extern DWORD scr_cy_res;

extern FSOUND_STREAM * music;

typedef void (*SceneAddress)(float, float);

FLASH flash;

extern float img_cx_scale;
extern float img_cy_scale;

TimeControl tc;
ImageAnim ia_kasparov;
ImageAnim ia_7heaven;
ImageAnim ia_fr8;
ImageAnim ia_sota;

aTex2D img_intro;

sgoScene y;

sgoScene	scene_partyplace;

sgoScene	scene_creditsy;
sgoScene	scene_kasparov;
sgoScene	scene_krzesla;
sgoScene	scene_7heaven;
sgoScene	scene_organki;
sgoScene	scene_noooga;
sgoScene	scene_fr8;
sgoScene	scene_kibel;
sgoScene	scene_nasze_teksty;

Cameras		cam_creditsy;
Cameras		cam_kasparov;
Cameras		cam_krzesla;
Cameras		cam_7heaven;
Cameras		cam_organki;
Cameras		cam_noooga;
Cameras		cam_fr8;
Cameras		cam_kibel;
Cameras		cam_nasze_teksty;

CAMERA camera;

/*int scenes_times[12] = {
	0,					
	0 + 3000,
	0 + 3000 + 52000,
	0 + 3000 + 60000,
	0 + 3000 + 84000,
	0 + 3000 + 94000,
	0 + 3000 + 134000,
	0 + 3000 + 154000,
	0 + 3000 + 174000,
	0 + 3000 + 184000,
	0 + 3000 + 208000,
	0 + 3000 + 218000,
	0 + 3000 + 253000};*/

int scenes_times[11] = {
	0,					
	0 + 3000,
	0 + 3000 + 52000,
	0 + 3000 + 60000,
	0 + 3000 + 84000,
	0 + 3000 + 94000,
	0 + 3000 + 134000,
	0 + 3000 + 154000,
	0 + 3000 + 164000,
	0 + 3000 + 188000,
	0 + 3000 + 233000};

SceneAddress scene_addresses[11];

int img_2d_times[5] = {3000 + 12000, 3000 + 67000, 3000 + 98000, 3000 + 138000, 3000 + 168000};
RECT img_2d_positions[5] = {
	(1024 - 468) / 2, (768 - 301) / 2, ((1024 - 468) / 2) + 468, ((768 - 301) / 2) + 301,
	200, 100, 200 + 636, 100 + 55,
	100, 300, 100 + 786, 300 + 56,
	50,  500, 50 + 636, 500 + 55,
	300, 300, 300 + 468, 300 + 54};

int fade_times[14] = {
	3000 + 7480,
	3000 + 15400,

	3000 + 52000,

	3000 + 60000,
	3000 + 60000 + 4204,
	3000 + 60000 + 6102,
	3000 + 60000 + 15680,
	3000 + 60000 + 17488,

	3000 + 84000,

	3000 + 94000,

	3000 + 134000,

	3000 + 154000,

	3000 + 164000,

	3000 + 188000};

aTex2D	img_progress40;
aTex2D	img_big_screen_scroll;
aTex2D	img_scroll;

aTex2D	img_napisy[5];
aTex2D	img_napisy_maski[5];

void drawBigScreen()
{
	glBegin(GL_QUADS);
	glNormal3f(0, 0, 1);
	glTexCoord2f(0, 1); glVertex3f(-24.500f, 43.784f, -71.50f);
	glTexCoord2f(1, 1); glVertex3f(19.800f, 43.784f, -71.50f);
	glTexCoord2f(1, 0); glVertex3f(19.800f, 10.564f, -71.50f);
	glTexCoord2f(0, 0); glVertex3f(-24.500f, 10.564f, -71.50f);
	glEnd();
}

void drawBigScreenScroll(float time, float ms)
{
	img_big_screen_scroll.bindTex();

	glBegin(GL_QUADS);
	glNormal3f(0, 0, 1);
	glTexCoord2f(0, 1.0f - (time / 45000.0f)); glVertex3f(-24.500f, 43.784f, -71.50f);
	glTexCoord2f(1, 1.0f - (time / 45000.0f)); glVertex3f(19.800f, 43.784f, -71.50f);
	glTexCoord2f(1, 1.0f - (time / 45000.0f) - 0.12f); glVertex3f(19.800f, 10.564f, -71.50f);
	glTexCoord2f(0, 1.0f - (time / 45000.0f) - 0.12f); glVertex3f(-24.500f, 10.564f, -71.50f);
	glEnd();
}

void drawScroll(float time, float ms)
{
	if ((time / 70000.0f) > 1.0f)
	{
		time = 70000.0f;
	}

	img_scroll.bindTex();

	glBegin(GL_QUADS);
	glNormal3f(0, 0, 1);
	glTexCoord2f(0, 1.0f - (time / 70000.0f)); glVertex2i(0, 0);
	glTexCoord2f(1, 1.0f - (time / 70000.0f)); glVertex2i(scr_cx_res, 0);
	glTexCoord2f(1, 1.0f - (time / 70000.0f) - 0.12f); glVertex2i(scr_cx_res, scr_cy_res);
	glTexCoord2f(0, 1.0f - (time / 70000.0f) - 0.12f); glVertex2i(0, scr_cy_res);
	glEnd();
}

void sceneIntroRoznasnienie()
{
	SetCurrentDirectory(program_directory);
	img_progress40.loadFromFile("data/2d/progress40.jpg");
}

void sceneIntroRoznasnienie(float time, float ms)
{
	ScreenTo2D();

	img_progress40.bindTex();
	
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	glBegin(GL_QUADS);
	glTexCoord2f(0, 1); glVertex2i(0, 0);
	glTexCoord2f(1, 1); glVertex2i(scr_cx_res, 0);
	glTexCoord2f(1, 0); glVertex2i(scr_cx_res, scr_cy_res);
	glTexCoord2f(0, 0); glVertex2i(0, scr_cy_res);
	glEnd();

	glDisable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);

	glColor4f(1, 1, 1, time / 3000.0f);
	glBegin(GL_QUADS);
	glVertex2i(0, 0);
	glVertex2i(scr_cx_res, 0);
	glVertex2i(scr_cx_res, scr_cy_res);
	glVertex2i(0, scr_cy_res);
	glEnd();

	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);

	glColor4f(1, 1, 1, 1);
}

// scena_intro z creditsami
void sceneCreditsy(float time, float ms)
{
	static bool initialized;

	if (!initialized)
	{
		initialized = true;
		FSOUND_Stream_Play(0, music);
	}

	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_creditsy.setCam(time);
	//SteerCamera(ms);
	scene_partyplace.renderScene(time);
	scene_creditsy.renderScene(time);

	img_intro.bindTex();
	drawBigScreen();
}

// scena przejsciowa - na ekranie kasparov
void sceneKasparov(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_kasparov.setCam(time);
	scene_partyplace.renderScene(time);
	//scene_kasparov.renderScene(time);

	ia_kasparov.translateAnim(ms);
	ia_kasparov.bindFrame();
	drawBigScreen();
}

// scena z krzeslami - na ekranie kasparov
void sceneKrzesla(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_krzesla.setCam(time);
	scene_partyplace.renderScene(time);
	scene_krzesla.renderScene(time);

	ia_kasparov.translateAnim(ms);
	ia_kasparov.bindFrame();
	drawBigScreen();
}

// scena przejsciowa - na ekranie 7heaven
void scene7heaven(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_7heaven.setCam(time);
	scene_partyplace.renderScene(time);
	//scene_7heaven.renderScene(time);

	ia_7heaven.translateAnim(ms);
	ia_7heaven.bindFrame();
	drawBigScreen();
}

// scena z muzykiem grajcym na organach - na ekranie 7heaven
void sceneOrganki(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_organki.setCam(time);
	scene_partyplace.renderScene(time);
	scene_organki.renderScene(time);

	ia_7heaven.translateAnim(ms);
	ia_7heaven.bindFrame();
	drawBigScreen();
}

// scena nooooga - na ekranie state of the art
void sceneNoooga(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_noooga.setCam(time);
	scene_partyplace.renderScene(time);
	scene_noooga.renderScene(time);

	ia_sota.translateAnim(ms);
	ia_sota.bindFrame();
	drawBigScreen();
}

// scena przejsciowa - na ekranie fr8
void sceneFr8(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_fr8.setCam(time);
	scene_partyplace.renderScene(time);
	//scene_7heaven.renderScene(time);

	ia_fr8.translateAnim(ms);
	ia_fr8.bindFrame();
	drawBigScreen();
}

// scena w kiblu
void sceneKibel(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_kibel.setCam(time);
	scene_partyplace.renderScene(time);
	scene_kibel.renderScene(time);

	ia_fr8.translateAnim(ms);
	ia_fr8.bindFrame();
	drawBigScreen();
}

// scena przejsciowa - na ekranie teksty nasze
void sceneNaszeTeksty(float time, float ms)
{
	ScreenTo3D();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glScalef(0.01f, 0.01f, 0.01f);

	cam_nasze_teksty.setCam(time);
	scene_partyplace.renderScene(time);
	//scene_7heaven.renderScene(time);

	drawBigScreenScroll(time, ms);
}

void sceneNapisyKoncowe(float time, float ms)
{
	ScreenTo2D();
	
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	drawScroll(time, ms);

	glEnable(GL_LIGHTING);
}

void DrawGLScene()
{
	float ms = tc.CheckFrameMS();
	float time = tc.GetTime() + 000000;
	
	for (int i = 10; i >= 0; i--)
	{
		if (time > scenes_times[i])
		{
			scene_addresses[i](time - scenes_times[i], ms);
			break;
		}
	}

	for (int i = 13; i >= 0; i--)
	{
		if ((time > (fade_times[i] - 500.0f)) && (time < (fade_times[i] + 500.0f)))
		{
			ScreenTo2D();

			glDisable(GL_LIGHTING);
			glDisable(GL_TEXTURE_2D);
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);

			glColor4f(1, 1, 1, (500.0f - (float)((float)(abs(time - fade_times[i])))) / 500.0f);
			glBegin(GL_QUADS);
			glVertex2i(0, 0);
			glVertex2i(scr_cx_res, 0);
			glVertex2i(scr_cx_res, scr_cy_res);
			glVertex2i(0, scr_cy_res);
			glEnd();

			glDisable(GL_BLEND);
			glEnable(GL_LIGHTING);

			glColor4f(1, 1, 1, 1);
		}
	}

	glEnable(GL_TEXTURE_2D);

	// wyswietlanie obrazkow 2d
	for (int i = 4; i >= 0; i--)
	{
		if ((time > (img_2d_times[i] - 3000.0f)) && (time < (img_2d_times[i] + 3000.0f)))
		{
			ScreenTo2D();

			glDisable(GL_LIGHTING);
			glEnable(GL_TEXTURE_2D);
			glEnable(GL_BLEND);

			img_napisy_maski[i].bindTex();
			glBlendFunc(GL_DST_COLOR, GL_ZERO);
			glBegin(GL_QUADS);
			glTexCoord2f(0, 1); glVertex2i(img_2d_positions[i].left, img_2d_positions[i].top);
			glTexCoord2f(1, 1); glVertex2i(img_2d_positions[i].right, img_2d_positions[i].top);
			glTexCoord2f(1, 0); glVertex2i(img_2d_positions[i].right, img_2d_positions[i].bottom);
			glTexCoord2f(0, 0); glVertex2i(img_2d_positions[i].left, img_2d_positions[i].bottom);
			glEnd();

			img_napisy[i].bindTex();
			glBlendFunc(GL_SRC_ALPHA, GL_ONE);
			glColor4f(1, 1, 1, (3000.0f - (float)((float)(abs(time - img_2d_times[i])))) / 2000.0f);
			glBegin(GL_QUADS);
			glTexCoord2f(0, 1); glVertex2i(img_2d_positions[i].left, img_2d_positions[i].top);
			glTexCoord2f(1, 1); glVertex2i(img_2d_positions[i].right, img_2d_positions[i].top);
			glTexCoord2f(1, 0); glVertex2i(img_2d_positions[i].right, img_2d_positions[i].bottom);
			glTexCoord2f(0, 0); glVertex2i(img_2d_positions[i].left, img_2d_positions[i].bottom);
			glEnd();

			glDisable(GL_BLEND);
			glEnable(GL_LIGHTING);

			glColor4f(1, 1, 1, 1);
		}
	}

	glEnable(GL_TEXTURE_2D);
	//showFPS(ms);

	if ((time > 41500 + 3000) && (time < 55000 + 3000))
	{
		static float next_beat;

		next_beat += ms;
		if (next_beat > 370.0f)
		{
			next_beat = 0.0f;
			flash.Reset();
		}
	}

	if ((time > 57424 + 3000) && (time < 63600 + 3000))
	{
		static float next_beat;

		next_beat += ms;
		if (next_beat > 370.0f)
		{
			next_beat = 0.0f;
			flash.Reset();
		}
	}

	if ((time > 81700 + 3000) && (time < 106000 + 3000))
	{
		static float next_beat;

		next_beat += ms;
		if (next_beat > 370.0f)
		{
			next_beat = 0.0f;
			flash.Reset();
		}
	}

	if ((time > 112200 + 3000) && (time < 159500 + 3000))
	{
		static float next_beat;

		next_beat += ms;
		if (next_beat > 370.0f)
		{
			next_beat = 0.0f;
			flash.Reset();
		}
	}

	if ((time > 166800 + 3000) && (time < 202000 + 3000))
	{
		static float next_beat;

		next_beat += ms;
		if (next_beat > 370.0f)
		{
			next_beat = 0.0f;
			flash.Reset();
		}
	}

	if ((time > 203200 + 3000) && (time < 234200 + 3000))
	{
		static float next_beat;

		next_beat += ms;
		if (next_beat > 370.0f)
		{
			next_beat = 0.0f;
			flash.Reset();
		}
	}

	ScreenTo2D();
	flash.Flash(scr_cx_res, scr_cy_res, ms/100.0f);
	glEnable(GL_LIGHTING);
	glDisable(GL_BLEND);

	glColor4f(1, 1, 1, 1);
}

void SetLight()
{
	float l_pos[4] = {0.0f, 0.0f, 0.0f, 1.0f};
	float l_amb[4] = {0.5f, 0.5f, 0.5f, 1.0f};
	float l_dif[4] = {1.0f, 1.0f, 1.0f, 1.0f};
	glLightfv(GL_LIGHT0, GL_POSITION, l_pos);
	glLightfv(GL_LIGHT0, GL_AMBIENT, l_amb);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, l_dif);
	glEnable(GL_LIGHT0);
	glEnable(GL_NORMALIZE);
	glEnable(GL_LIGHTING);
}

void InitScene()
{
	for (int i = 0; i < 5; i++)
	{
		img_2d_positions[i].left *= img_cx_scale;
		img_2d_positions[i].right *= img_cx_scale;
		img_2d_positions[i].top *= img_cy_scale;
		img_2d_positions[i].bottom *= img_cy_scale;
	}

	sceneIntroRoznasnienie();

	scene_addresses[0] = sceneIntroRoznasnienie;
	scene_addresses[1] = sceneCreditsy;
	scene_addresses[2] = sceneKasparov;
	scene_addresses[3] = sceneKrzesla;
	scene_addresses[4] = scene7heaven;
	scene_addresses[5] = sceneOrganki;
	scene_addresses[6] = sceneNoooga;
	scene_addresses[7] = sceneFr8;
	scene_addresses[8] = sceneKibel;
	scene_addresses[9] = sceneNaszeTeksty;
	scene_addresses[10] = sceneNapisyKoncowe;

	SetLight();

	SetCurrentDirectory(program_directory);
	ia_kasparov.loadAnim("data/image_anims/kasparov/kasparov_", "jpg", 87, 3);
	ia_kasparov.setFPS(14);

	SetCurrentDirectory(program_directory);
	ia_7heaven.loadAnim("data/image_anims/7heaven/7heaven_", "jpg", 117, 3);
	ia_7heaven.setFPS(14);

	SetCurrentDirectory(program_directory);
	ia_fr8.loadAnim("data/image_anims/fr8/fr8_", "jpg", 115, 3);
	ia_fr8.setFPS(14);

	SetCurrentDirectory(program_directory);
	ia_sota.loadAnim("data/image_anims/sota/sota_", "jpg", 121, 3);
	ia_sota.setFPS(14);

	////// LOADING SCENES
	SetCurrentDirectory(program_directory);
	scene_partyplace.loadScene("data/scenes/partyplace.sgo");

	SetCurrentDirectory(program_directory);
	scene_creditsy.loadScene("data/scenes/00_creditsy.sgo");

	SetCurrentDirectory(program_directory);
	//scene_kasparov.loadScene("data/scenes/00_creditsy.sgo");

	SetCurrentDirectory(program_directory);
	scene_krzesla.loadScene("data/scenes/02_krzesla.sgo");

	SetCurrentDirectory(program_directory);
	//scene_7heaven.loadScene("data/scenes/00_creditsy.sgo");

	SetCurrentDirectory(program_directory);
	scene_organki.loadScene("data/scenes/04_organki.sgo");

	SetCurrentDirectory(program_directory);
	scene_noooga.loadScene("data/scenes/05_noooga.sgo");

	SetCurrentDirectory(program_directory);
	scene_kibel.loadScene("data/scenes/07_kibel.sgo");

	HDC hdc = wglGetCurrentDC();
	wglUseFontBitmaps(hdc, 0, 255, 1000);
	glListBase(1000);

	////// LOADING CAMERAS
	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/00_creditsy/");
	cam_creditsy.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/01_kasparov/");
	cam_kasparov.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/02_krzesla/");
	cam_krzesla.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/03_7heaven/");
	cam_7heaven.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/04_organki/");
	cam_organki.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/05_noooga/");
	cam_noooga.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/06_fr8/");
	cam_fr8.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/07_kibel/");
	cam_kibel.loadCameras("cameras_time.cfg");

	SetCurrentDirectory(program_directory);
	SetCurrentDirectory("./data/cam_routes/08_nasze_teksty/");
	cam_nasze_teksty.loadCameras("cameras_time.cfg");

	progressReady();

	SetCurrentDirectory(program_directory);
	img_intro.loadFromFile("./data/2d/intro_screen.jpg");

	SetCurrentDirectory(program_directory);
	img_big_screen_scroll.loadFromFile("./data/2d/big_screen_shit.jpg");

	SetCurrentDirectory(program_directory);
	img_scroll.loadFromFile("./data/2d/scroll.jpg");

	SetCurrentDirectory(program_directory);
	img_napisy[0].loadFromFile("./data/2d/title.png");
	SetCurrentDirectory(program_directory);
	img_napisy[1].loadFromFile("./data/2d/abs2003.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy[2].loadFromFile("./data/2d/citizenparty.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy[3].loadFromFile("./data/2d/syf2004.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy[4].loadFromFile("./data/2d/any_party.jpg");

	SetCurrentDirectory(program_directory);
	img_napisy_maski[0].loadFromFile("./data/2d/title_maska.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy_maski[1].loadFromFile("./data/2d/abs2003_maska.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy_maski[2].loadFromFile("./data/2d/citizenparty_maska.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy_maski[3].loadFromFile("./data/2d/syf2004_maska.jpg");
	SetCurrentDirectory(program_directory);
	img_napisy_maski[4].loadFromFile("./data/2d/any_party_maska.jpg");

	tc.Start();
}

void DeInitScene()
{
}