#include "sgoanim.h"

sgoAnim::sgoAnim(void)
{
	translate	= NULL;
	rotate		= NULL;
}

void sgoAnim::loadAnim(FileHolder &fh)
{
	WORD	c_keys_pos;
	WORD	c_keys_rotate;
	WORD	c_keys_scale;
	int		frame;

	c_keys_pos = fh.readWord();
	if (c_keys_pos > 0)
	{
		translate = new aAnim;
		translate ->createKeySlots(0, c_keys_pos);
		for (WORD i = 0; i < c_keys_pos; i++)
		{
			G3DVECTOR	pos;
			frame = fh.readInt();
			pos.x = fh.readFloat();
			pos.y = fh.readFloat();
			pos.z = fh.readFloat();
			translate ->setKey(i, frame, &pos, NULL, NULL);
		}
	}

	c_keys_rotate = fh.readWord();
	if (c_keys_rotate > 0)
	{
		rotate = new aAnim;
		rotate ->createKeySlots(0, c_keys_rotate);
		for (WORD i = 0; i < c_keys_rotate; i++)
		{
			float		angle;
			G3DVECTOR	axis;
			QUAT		quat;

			frame = fh.readInt();
			angle = fh.readFloat();
			axis.x = fh.readFloat();
			axis.y = fh.readFloat();
			axis.z = fh.readFloat();

			quat.RotateToQuat(axis.x, axis.y, axis.z, -angle);

			//ta linijka jest zajebista i jestem z niej dumny, chodzi o to, ze 3dmax interpolacja obrotu do nastepnej
			//klatki, zalezy od poprzedniej, wiec jak przetwarzam np key 3, to musze najpierw obrocic
			//obiekt o 0, 1, 2 i dopiero interpolacja na 3, a nie od razu:))
			if (i > 0) quat = rotate ->getKeyData(i - 1) ->rotate * quat;

			rotate ->setKey(i, frame, NULL, &quat, NULL);
		}
	}

	c_keys_scale = fh.readWord();
	if (c_keys_scale > 0)
	{
		scale = new aAnim;
		scale ->createKeySlots(0, c_keys_scale);
		for (WORD i = 0; i < c_keys_scale; i++)
		{
			G3DVECTOR _scale;
			frame = fh.readInt();
			_scale.x = fh.readFloat();
			_scale.y = fh.readFloat();
			_scale.z = fh.readFloat();
			scale ->setKey(i, frame, NULL, NULL, &_scale);
		}
	}
}

void sgoAnim::setMatrix(float time)
{
	if (translate) translate ->setMatrixOnFrame((DWORD) time, aAnim::ANIM_MOVE);
	if (rotate) rotate ->setMatrixOnFrame((DWORD) time, aAnim::ANIM_ROTATE);
	if (scale) scale ->setMatrixOnFrame((DWORD) time, aAnim::ANIM_SCALE);
}