#include "sgomesh.h"

sgoMesh::sgoMesh()
{
	tex		= NULL;
}

void sgoMesh::loadObject(FileHolder &fh)
{
	c_verts = fh.readWord();
	verts = new sgoVertex[c_verts];
	for (int j = 0; j < c_verts; j++)
	{
		verts[j].pos.x = fh.readFloat();
		verts[j].pos.y = fh.readFloat();
		verts[j].pos.z = fh.readFloat();
	}

	c_coords = fh.readWord();
	coords = new sgoCoord[c_coords];
	for (int j = 0; j < c_coords; j++)
	{
		coords[j].u = fh.readFloat();
		coords[j].v = fh.readFloat();
	}

	c_faces = fh.readWord();
	faces = new sgoFace[c_faces];

	for (int j = 0; j < c_faces; j++)
	{
		faces[j].vert_i[0] = fh.readWord();
		faces[j].vert_i[1] = fh.readWord();
		faces[j].vert_i[2] = fh.readWord();

		if (c_coords > 0)
		{
			faces[j].coord_i[0] = fh.readWord();
			faces[j].coord_i[1] = fh.readWord();
			faces[j].coord_i[2] = fh.readWord();
		}

		faces[j].normal.CrossProductFrom3Points(verts[faces[j].vert_i[0]].pos, verts[faces[j].vert_i[1]].pos, verts[faces[j].vert_i[2]].pos);
		faces[j].normal.Normalize();

	}

	tex_index = fh.readWord();
}

void sgoMesh::buildList()
{
	list_id = glGenLists(1);
	glNewList(list_id, GL_COMPILE);

	glBegin(GL_TRIANGLES);
	for (int j = 0; j < c_faces; j++)
	{
		glNormal3f(faces[j].normal.x, faces[j].normal.y, faces[j].normal.z);

		glTexCoord2f(coords[faces[j].coord_i[0]].u * tex ->u_tiling, coords[faces[j].coord_i[0]].v * tex ->v_tiling);
		glVertex3f(verts[faces[j].vert_i[0]].pos.x, verts[faces[j].vert_i[0]].pos.y, verts[faces[j].vert_i[0]].pos.z);

		glTexCoord2f(coords[faces[j].coord_i[1]].u * tex ->u_tiling, coords[faces[j].coord_i[1]].v * tex ->v_tiling);
		glVertex3f(verts[faces[j].vert_i[1]].pos.x, verts[faces[j].vert_i[1]].pos.y, verts[faces[j].vert_i[1]].pos.z);

		glTexCoord2f(coords[faces[j].coord_i[2]].u * tex ->u_tiling, coords[faces[j].coord_i[2]].v * tex ->v_tiling);
		glVertex3f(verts[faces[j].vert_i[2]].pos.x, verts[faces[j].vert_i[2]].pos.y, verts[faces[j].vert_i[2]].pos.z);
	}
	glEnd();

	glEndList();
}

void sgoMesh::renderMesh()
{
	if (tex != NULL)
	{
		tex ->texture ->bindTex();
		glEnable(GL_TEXTURE_2D);
	}
	else
	{
		glDisable(GL_TEXTURE_2D);
	}

	glCallList(list_id);
}