//uniform vec4 fvAmbient;
//uniform vec4 fvSpecular;
//uniform vec4 fvDiffuse;
//uniform float fSpecularPower;

uniform sampler2D envMap;
//uniform sampler2D solidMap;
uniform float fSpecularPower;

varying vec2 Texcoord2;
varying vec2 Texcoord;
varying vec3 ViewDirection;
varying vec3 LightDirection;
varying vec3 Normal;

void main( void )
{
   vec4 fvAmbient = vec4(0.1686, 0.1686, 0.1686, 1.0);
   vec4 fvSpecular = vec4(0.8902, 0.8902, 0.8902, 1.0);
   vec4 fvDiffuse = vec4(0.3863, 0.3863, 0.3863, 1.0);

   vec3  fvLightDirection = normalize( LightDirection );
   vec3  fvNormal         = normalize( Normal );
   float fNDotL           = dot( fvNormal, fvLightDirection );

   vec3  fvReflection     = normalize( ( ( 2.0 * fvNormal ) * fNDotL ) - fvLightDirection );
   vec3  fvViewDirection  = normalize( ViewDirection );
   float fRDotV           = max( 0.0, dot( fvReflection, fvViewDirection ) );

   vec4  fvBaseColor      = texture2D( envMap, Texcoord );
//   vec4  fvSolidMap       = texture2D( solidMap, Texcoord2);
   //vec4  tmix = ((fvBaseColor/2.0)+(fvSolidMap/2.0));

   vec4  fvTotalAmbient   = fvAmbient;
   vec4  fvTotalDiffuse   = fNDotL * fvBaseColor; // fvDiffuse *
   vec4  fvTotalSpecular  = fvSpecular * ( pow( fRDotV, fSpecularPower ) );

   gl_FragColor = ( fvTotalAmbient + fvTotalDiffuse + fvTotalSpecular);

}