#include "prewx.h"
#include "sprite.h"


Sprite::Sprite(Level *le, DrawEngine *de, int s_index, float x, float y, int i_lives)
{
	draw = de;
	pos.y = y;
	pos.x = x;

	spriteIndex = s_index;

	numLives = i_lives;

	retning.x = 1;
	retning.y = 0;

	classID = SPRITE_CLASSID;

	level = le;
	delay = 60;
	sistTid = 0;
	updateSprite_var = false;

}

Sprite::~Sprite()
{
	doErase(pos.x, pos.y);
}

vector Sprite::getPosition(void)
{
	return pos;
}

float Sprite::getX(void)
{
	return pos.x;
}

float Sprite::getY(void)
{
	return pos.y;
}

void Sprite::addLives(int num)
{
	numLives += num;
}

int Sprite::getLives(void)
{
	return numLives;
}

bool Sprite::isAlive(void)
{
	if(numLives > 0)
		return true;

	return false;
}

bool Sprite::move(float x, float y)
{
	int xpos = (int)(pos.x + x);
	int ypos = (int)(pos.y + y);

	if(isValidMove(xpos,ypos))
	{

/*
				for (Iter = level->npc.begin(); Iter != level->npc.end(); Iter++)
		{
			if((*Iter) != this && (int)(*Iter)->getX() == xpos && (int)(*Iter)->getY() == ypos)
			{
				
				return false;
			}
		}*/

		doErase(pos.x, pos.y);
		pos.y += y;
		pos.x += x;

		retning.x = x;
		retning.y = y;

		
		doDraw(pos.x , pos.y);
		
		return true;
	}
	return false;
}

void Sprite::doDraw(float x, float y)
{
	draw->drawSprite(spriteIndex, (int)x, (int)y);
}

void Sprite::doErase(float x, float y)
{
	
	draw->eraseSprite((int)x, (int)y);
}

bool Sprite::isValidMove(int xpos, int ypos)
{
	if (xpos >= 0 && xpos < level->getWidth() && ypos >= 0 && ypos < level->getHeight() && level->level[xpos][ypos] != BLOCK_FULL)
	{
		return true;
	}
	else
	{
		return false;
	}
}

void Sprite::idleUpdate(void)
{

}

void Sprite::setPosition(int x, int y)
{
	//wxMessageBox(_T("Velkommen til setPosition!"),_T("..."));
   doErase(pos.x, pos.y);
   //wxMessageBox(_T("Sprite slettet!"),_T(".."));
   retning.x = retning.y = -100;
   pos.x = x;
   pos.y = y;

   doDraw(pos.x, pos.y);

   //wxMessageBox(_T("Sprite satt p plass!"),_T(".."));
}

void Sprite::setLevel(Level *newLevel)
{
   level = newLevel;
}

void Sprite::update(void)
{
   doDraw(pos.x, pos.y);
}

int Sprite::getID(void)
{
   return classID;
}

void Sprite::setFart(int speed)
{
	if(speed > 100) speed = 100;
	delay = 200 - (speed / 100.0f) * 200;
}

int Sprite::getFart(void)
{
	return delay;
}
void Sprite::setTid(long time)
{
	if(time - sistTid > delay)
	{
		sistTid = time;
		updateSprite_var = true;
	}
}

bool Sprite::updateSprite(void)
{
	bool var = updateSprite_var;

	updateSprite_var = false;
	return var;
}
