uniform sampler2D T0;
varying vec2 texCoord;

void main(void) 
{
   float delta = 0.002;
   float asp = 4.0;
   vec3 col = texture2D(T0, texCoord.xy).xyz;
   vec3 col1 = texture2D(T0, texCoord.xy+vec2(delta,0.0)).xyz;
   vec3 col2 = texture2D(T0, texCoord.xy+vec2(-delta,0.0)).xyz;
   vec3 col3 = texture2D(T0, texCoord.xy+vec2(0.0,delta * asp)).xyz;
   vec3 col4 = texture2D(T0, texCoord.xy+vec2(0.0,-delta * asp)).xyz;
   // float edgeness = max(col1.x-col.x,max(col2.x-col.x,max(col3.x-col.x,col4.x-col.x)));
   float maxcol = min(col1.x, min(col2.x, min(col3.x, col4.x)));
   float edgeness = abs(maxcol - col.x);
   gl_FragColor = vec4(edgeness*2.0,edgeness,edgeness, col.x);
   // gl_FragColor = vec4(1.0,0.0,1.0,col.x);
}
                            
