float4x4 WorldViewProjMatrix; 
//float4x4 WorldMatrix;
float4      camerapos;


struct VS_OUTPUT
{
   float4 Pos: POSITION;
   float4 PosInt: TEXCOORD1;
   float2 Tex: TEXCOORD0;
};

VS_OUTPUT Vertex_Shader_main( float4 Pos: POSITION,
                float2 Tex:  TEXCOORD0 )
{
   VS_OUTPUT Out = (VS_OUTPUT) 0; 

   Out.Pos = mul (Pos,WorldViewProjMatrix);
   Out.PosInt = (Pos);
   Out.Tex = Tex;  
   return Out;
}

sampler texturas[2];


float4 Pixel_Shader_main( float4 Diff: COLOR0,
             float2 Tex: TEXCOORD0, float4 PosInt:TEXCOORD1 ) : COLOR
{
   float4 res;
   float2 tmp = tex2D(texturas[1],Tex+length(camerapos)*0.1);
    res = tex2D( texturas[0], Tex +tmp*0.8);

    res.w =  length(normalize(PosInt-camerapos));
return res;
}





//--------------------------------------------------------------//
// Technique Section for Effect Group 1
//--------------------------------------------------------------//
technique Render_To_Texture
{
   pass Pass_0
   {
      //CULLMODE = NONE;
 
      CULLMODE = NONE;
      BLENDOP = ADD;
      ALPHABLENDENABLE = TRUE;
      SRCBLEND = SRCALPHA;
      DESTBLENDALPHA = INVSRCALPHA;
 
      VertexShader = compile vs_2_0 Vertex_Shader_main();
      PixelShader = compile ps_2_0 Pixel_Shader_main();
   }

}













