// var aa1 = new Array(0, 0, 10);
// var aa2 = new Array(0, 0, 0);

// ASCII(tm) 3D(tm) model
//   4-----5     -y  z+
//  /  2  /|      | /
// 0-----116      |/ 
// |  0  |/     --+-----x+
// 3-----2       /
//              z-

function Rect(side){
    this.points = side;
    this.visible = false;
    this.changed = false;
    this.stroke = "black";
    this.fill = "none";
}

function Cube(p0, p1, p2, p3, p4, p5, p6, p7, spinaxel) {
    // p0...7: the cube's corners
    this.path = new Array(p0, p1, p2, p3, p4, p5, p6, p7);
    var side0 = new Array(this.path[0], this.path[1], 
	this.path[2], this.path[3]); // front
    var side1 = new Array(this.path[1], this.path[5], 
	this.path[6], this.path[2]); // right side
    var side2 = new Array(this.path[4], this.path[5], 
	this.path[1], this.path[0]); // top
    var side3 = new Array(this.path[0], this.path[4], 
	this.path[7], this.path[3]); // left side
    var side4 = new Array(this.path[4], this.path[5], 
	this.path[6], this.path[7]); // back
    var side5 = new Array(this.path[7], this.path[6], 
	this.path[2], this.path[3]); // bottom
    
    this.sides = new Array(side0, side1, side2, side3, side4, side5);

    var rect0 = new Rect(this.sides[0]);
    var rect1 = new Rect(this.sides[1]);
    var rect2 = new Rect(this.sides[2]);
    var rect3 = new Rect(this.sides[3]);
    var rect4 = new Rect(this.sides[4]);
    var rect5 = new Rect(this.sides[5]);

    this.polys = new Array(rect0, rect1, rect2, rect3, rect4, rect5);

    this.angleiter = 0;
    this.increment = 1;
    
    this.spinaxel = spinaxel;
}

function cube_loader(container_id){
    var p0 = new Array(-50, -50, 150);
    var p1 = new Array(50, -50, 150);
    var p2 = new Array(50, 50, 150);
    var p3 = new Array(-50, 50, 150);
    var p4 = new Array(-50, -50, 250);
    var p5 = new Array(50, -50, 250);
    var p6 = new Array(50, 50, 250);
    var p7 = new Array(-50, 50, 250);
    var cube = new Cube(p0, p1, p2, p3, p4, p5, p6, p7);
    createNewPath(cube.polys[0].points, "red",
		  cube.polys[0].stroke, container_id);
    createNewPath(cube.polys[1].points, cube.polys[1].fill,
		  cube.polys[1].stroke, container_id);
    createNewPath(cube.polys[2].points, cube.polys[2].fill,
		  cube.polys[2].stroke, container_id);
    createNewPath(cube.polys[3].points, cube.polys[3].fill,
		  cube.polys[3].stroke, container_id);
    createNewPath(cube.polys[4].points, cube.polys[4].fill,
		  cube.polys[4].stroke, container_id);
    createNewPath(cube.polys[5].points, cube.polys[5].fill,
		  cube.polys[5].stroke, container_id);
	cube.spinaxel = new Array(
	    new Array(0, 60, 500),
	    new Array(0, 10, 500)
	);

//     createNewPath(cube.polys[1].points, "none", "#D5DED9", container_id);
//     createNewPath(cube.polys[2].points, "none", "#7A6A53", container_id);
//     createNewPath(cube.polys[3].points, "none", "#D5DED9", container_id);
//     createNewPath(cube.polys[4].points, "none", "#D9CEB2", container_id);
//     createNewPath(cube.polys[5].points, "none", "#7A6A53", container_id);
    var iter = 0;
    return setInterval(playAnimation, 40, cube, container_id, iter);
    // line_rotator = ...
}

function crappy_cube_loader(cube, container_id) {
    createNewPath(cube.polys[0].points, cube.polys[0].stroke,
		  cube.polys[0].fill, container_id);
    createNewPath(cube.polys[1].points, cube.polys[1].stroke,
		  cube.polys[1].fill, container_id);
    createNewPath(cube.polys[2].points, cube.polys[2].stroke,
		  cube.polys[2].fill, container_id);
    createNewPath(cube.polys[3].points, cube.polys[3].stroke,
		  cube.polys[3].fill, container_id);
    createNewPath(cube.polys[4].points, cube.polys[4].stroke,
		  cube.polys[4].fill, container_id);
    createNewPath(cube.polys[5].points, cube.polys[5].stroke,
		  cube.polys[5].fill, container_id);
    return setInterval(playAnimation, 40, cube, container_id);
}

function playAnimation(cube, container) {
    calculateRotations(cube);
    drawPolys(cube.polys, container);
}

function calculateRotations(cube) {
    cube.angleiter += cube.increment;
    if(cube.angleiter > 200) {cube.angleiter = 1;}
    var angle = cube.angleiter*Math.PI/100.0;
    var tempPath = clonePath(cube.path);
    rotatePathArbit(tempPath, cube.spinaxel[0], cube.spinaxel[1], angle);
    updateCube(cube, tempPath);
}

function updateCube(cube, path) {
    // Calculate which sides are shown
    updateSides(cube, path);
    var camVector;
    var normal;
    for(var i = 0; i < cube.sides.length; i++){
        switch(i){
        case 0: 
            normal = createVector(cube.sides[4][0], cube.sides[0][0]);
            break;
        case 1:
            normal = createVector(cube.sides[0][0], cube.sides[1][0]);
            break;
        case 2:
            normal = createVector(cube.sides[0][3], cube.sides[2][3]);
            break;
        case 3:
            normal = createVector(cube.sides[1][0], cube.sides[0][0]);
            break;
        case 4:
            normal = createVector(cube.sides[0][0], cube.sides[4][0]);
            break;
        case 5:
            normal = createVector(cube.sides[2][3], cube.sides[0][3]);
            break;
        default:
            log("updateCube kyrvahti");
        }
        camVector = createVector(cube.sides[i][0], campos);
        if(dotProduct(normal, camVector) < 0) {
            if(cube.polys[i].visible){
                cube.polys[i].visible = false;
                cube.polys[i].changed = true;
            }
        }
        else{
            if(!cube.polys[i].visible){
                cube.polys[i].visible = true;
                cube.polys[i].changed = true;
            }
        }
    }
}

function updateSides(cube, path) {
    cube.sides[0][0] = path[0];
    cube.sides[0][1] = path[1];
    cube.sides[0][2] = path[2];
    cube.sides[0][3] = path[3];

    cube.sides[1][0] = path[1];
    cube.sides[1][1] = path[5];
    cube.sides[1][2] = path[6];
    cube.sides[1][3] = path[2];

    cube.sides[2][0] = path[4];
    cube.sides[2][1] = path[5];
    cube.sides[2][2] = path[1];
    cube.sides[2][3] = path[0];

    cube.sides[3][0] = path[0];
    cube.sides[3][1] = path[4];
    cube.sides[3][2] = path[7];
    cube.sides[3][3] = path[3];

    cube.sides[4][0] = path[4];
    cube.sides[4][1] = path[5];
    cube.sides[4][2] = path[6];
    cube.sides[4][3] = path[7];

    cube.sides[5][0] = path[7];
    cube.sides[5][1] = path[6];
    cube.sides[5][2] = path[2];
    cube.sides[5][3] = path[3];
}
