function Star(path, stroke, fill) {
    this.path = path;
    this.stroke = stroke;
    this.fill = fill;
    this.svg = null;

    this.create = function(container_id) {
	this.svg = createNewPath(this.path, this.stroke, this.fill, 
				 container_id);
    }
    
    this.createUse = function(container_id) {
	this.svg = document.createElementNS(svgNS, 'use');
	this.svg.setAttributeNS(xlinkNS, "href", "#STAR");
	document.getElementById(container_id).appendChild(this.svg);
    }
    
    this.redraw = function() {
	drawClosedPath(this.svg, this.path);
    }
    
    this.scale = function(scale) {
	this.svg.setAttributeNS(null, 'transform', 'scale(' + scale + ')');
    }
    
    this.angleiter = 0;
    this.dir = 1;
	
}

function star_runner(container_id) {
    var stars = new Array(3);
    var starpath2=new Array(
	new Array(403, 639, 0),
	new Array(286, 540, 0), // < 1
	new Array(200, 666, 0),
	new Array(187, 514, 0),
	new Array(37, 541, 0),
	new Array(136, 425, 0),
	new Array(10, 338, 0),
	new Array(162, 326, 0),
	new Array(135, 176, 0),
	new Array(251, 275, 0), // < 9
	new Array(338, 149, 0),
	new Array(350, 301, 0),
	new Array(501, 274, 0),
	new Array(401, 390, 0),
	new Array(527, 477, 0),
	new Array(375, 489, 0),
	new Array(403, 639, 0)
    );    
    var starpath1 = new Array(
	new Array(540, 865, 0),
	new Array(311, 671, 0),
	new Array(141, 917, 0),
	new Array(117, 619, 0),
	new Array(-177, 673, 0),
	new Array(17, 445, 0),
	new Array(-230, 274, 0),
	new Array(69, 251, 0),
	new Array(15, -44, 0),
	new Array(243, 150, 0),
	new Array(413, -96, 0),
	new Array(437, 202, 0),
	new Array(732, 148, 0),
	new Array(537, 376, 0),
	new Array(784, 546, 0),
	new Array(485, 570, 0),
	new Array(540, 865, 0)
    );   

    var starpath0 = new Array(
	new Array(668, 1092, 0),
	new Array(326, 800, 0),
	new Array(71, 1170, 0),
	new Array(35, 722, 0),
	new Array(-407, 804, 0),
	new Array(-116, 462, 0),
	new Array(-486, 207, 0),
	new Array(-38, 171, 0),
	new Array(-119, -271, 0),
	new Array(223, 20, 0),
	new Array(478, -350, 0),
	new Array(514, 98, 0),
	new Array(956, 17, 0),
	new Array(664, 359, 0),
	new Array(1034, 614, 0),
	new Array(587, 650, 0),
	new Array(668, 1092, 0)
    );
    
    for (var i=0; i < starpath0.length; i++) {
	starpath0[i][0] -= 300;
	starpath0[i][1] -= 400;
    }
    for (var i=0; i < starpath1.length; i++) {
	starpath1[i][0] -= 300;
	starpath1[i][1] -= 400;
    }
    for (var i=0; i < starpath2.length; i++) {
	starpath2[i][0] -= 300;
	starpath2[i][1] -= 400;
    }
    
    stars[0] = new Star(starpath0, 'none', '#7A6A53');
    stars[0].create(container_id);
    stars[0].redraw();

    stars[1] = new Star(starpath1, 'none', 'white');
    stars[1].create(container_id);
    stars[1].dir = -1;
    stars[1].redraw();

    stars[2] = new Star(starpath2, 'none', '#7A6A53');
    stars[2].create(container_id);
    stars[2].redraw();

    var starcenter = new Array(
	(starpath2[1][0] + starpath2[9][0])/2,
	(starpath2[1][1] + starpath2[9][1])/2,
	(starpath2[1][2] + starpath2[9][2])/2
    );
    var sa1 = clonePoint(starcenter);
    var sa2 = clonePoint(starcenter);
    sa2[2] += 10;
    star_interval = setInterval(star_rotator, 40, stars, sa1, sa2);
    
    var texts = new Array(
	"It's Pure JavaScript + SVG",
	"Code by Speque & Nailor",
	"Music by vveli");
    var coords = new Array(
	new Array(-250, 0),
	new Array(-40, 100),
	new Array(-300, -100)
    );
    textObj = new Text(texts[0], 40, 'Courier', 'black', coords[0]);
    textObj.createSVGRef('t2');
    star_textInterval = setInterval(shakingText, 100, textObj);
    setTimeout(DemoCube.switchText, 3000, textObj, texts[1], coords[1]);
    setTimeout(DemoCube.switchText, 6000, textObj, texts[2], coords[2]);

}

function star_rotator(stars, sa1, sa2) {
    for (var i=0; i< stars.length; i++) {
	var star = stars[i];
	star.angleiter += star.dir;
	if (star.angleiter > 200 || star.angleiter < -200) {
	    star.angleiter = 1*star.dir; 
	}
	var angle = star.angleiter*Math.PI/100.0;
	var tempPath = clonePath(star.path);
	rotatePathArbit(tempPath, sa1, sa2, angle);
	drawClosedPath(star.svg, tempPath);
    }
}
    