uniform float xDistortion;
uniform float yDistortion;

uniform float stripesDensity;
uniform float circlesDensity;
uniform float circleWeight;

uniform sampler1D palette;
uniform float paletteOffset;
uniform float paletteScale;

//uniform sampler1D paletteInside;

void main()
{
	// ----------------------------- Boogiebrot iteration initialization start ---
	const int maxIter = 45;
	const float bailout = 1.0e4;
	int numIter = 0;

	// Initial position
	vec2 z = gl_TexCoord[0].xy, zPrevious;
	vec2 pixel = z;

	// Bailout flag
	bool isInside = true;
	float distance;
	// ----------------------------- Boogiebrot iteration initialization end -----
	
	// Average index
	float average = 0.0, averagePrev;
	float stripeTerm, circleTerm;
	
	float stripeWeight = 1.0 - circleWeight;
	
	// Iterate
	while ((isInside) && (numIter < maxIter))
	{
		// ------------------------- Boogiebrot iteration start -----
		float A = z.x*z.x - z.y*z.y;
		float B = 2.0*z.x*z.y;
		float C = 1.0 + z.x*xDistortion - z.y*yDistortion;
		float D = z.x*yDistortion + z.y*xDistortion;
		
		// Nominator vector
		vec2 AB = vec2(A, B);
		// Denominator vector
		vec2 CD = vec2(C, D);

		// Save previous iteration needed for divergence estimation
		zPrevious = z;

		// Iterate the formula z(n+1) = z(n)^2 / (1 + d*z) + C
		z = vec2(dot(AB, CD), B*C - A*D) / (dot(CD,CD)) + pixel;
		
		distance = length(z);

		// Test bailout
		isInside = (distance > bailout) ? false : true;
		
		// Next iteration		
		numIter++;
		// ------------------------- Boogiebrot iteration end -------
		
		// Stripe term
		stripeTerm = sin(stripesDensity * atan(z.x, z.y));
		
		// Circle term
		circleTerm = sin(circlesDensity * log(distance));

		averagePrev = average;
		average += stripeWeight * stripeTerm + circleWeight * circleTerm;

		// Test bailout
		isInside = (distance > bailout) ? false : true;
		
		// Next iteration		
		numIter++;
	}

	// Estimate rate of divergence	
	float power = log(distance) / log(length(zPrevious));

	// Calculate the decimal part of the smooth iteration count
	float smoothDecimal =  1.0 + log(log(bailout) / log(distance)) / log(power);

	
	// Interpolate using decimal part
	average = smoothDecimal * average / float(numIter + 1)
		+ (1.0 - smoothDecimal) * averagePrev / float(numIter);


	// Inside coloring
	if (isInside)
	{
		gl_FragColor = vec4(0.4, 0.15, 0.10, 1.0);
		return;
	}

	// Outside coloring
	gl_FragColor = texture1D(palette, paletteScale * average + paletteOffset);
}
