#include "Core/ImagePrologue.fx"

void VS(float3 Pos : POSITION, float3 UV : TEXCOORD0,
				out float4 oPos : POSITION, out float4 oUV : TEXCOORD0)
{
	oPos=mul(float4(Pos, 1), g_mWorldViewProj);
	oUV=mul(float4(UV, 1), g_mTex1Transform);
}

float4 PS(float2 UV : TEXCOORD0) : COLOR
{
	return tex2D(Sampler, UV)*g_f4Col;
}

float4 PSNoTexAlpha(float2 UV : TEXCOORD0) : COLOR
{
	return tex2D(Sampler, UV)*float4(g_f4Col.xyz, 0)+float4(0, 0, 0, g_f4Col.w);
}


#include "Core/ImageEpilogue.fx"