vec2 = {};

vec2.mt = {}; --metatable

function vec2.new(a, b)
	local v = {x=a, y=b};
	setmetatable(v, vec2.mt);
	return v;
end

function vec2.add(a, b)
	return vec2.new(a.x+b.x, a.y+b.y);
end

function vec2.sub(a, b)
	return vec2.new(a.x-b.x, a.y-b.y);
end

function vec2.negate(a)
	a.x=-a.x; a.y=-a.y;
end

function vec2.negated(a)
	return vec2.new(-a.x, -a.y);
end
	
function vec2.mul(a, b)
    if( type(a) == "number" ) then
        return vec2.new(a*b.x, a*b.y)
    elseif( type(b) == "number" ) then
        return vec2.new(b*a.x, b*a.y)
    else
        return vec2.new(a.x*b.x, a.y*b.y)
    end
end

function vec2.div(a, b)
	local r=1/b
	return vec2.new(a.x*r, a.y*r);
end

function vec2.dot(a, b)
	return a.x*b.x+a.y*b.y;
end

function vec2.lengthsq(a)
	return a.x*a.x+a.y*a.y;
end

function vec2.length(a)
	return math.sqrt(vec2.lengthsq(a));
end

function vec2.normalize(a)
	local l=vec2.length(a);
	a.x=a.x/l; a.y=a.y/l;
end

function vec2.normalized(a)
	local l=vec2.length(a);
	return vec2.new(a.x/l, a.y/l);
end

vec2.mt.__add=vec2.add;
vec2.mt.__sub=vec2.sub;
vec2.mt.__unm=vec2.negate;
vec2.mt.__mul=vec2.mul;
vec2.mt.__div=vec2.div;