float4x4 g_mWorldViewProj;
float4x4 g_mWorld;

texture g_tEnvMap;

texture g_tTex;

float3 g_f3DistortScale=float3(10, 10, 10);
float3 g_f3DistortOffset=float3(0.05f, 0.05f, 0.05f);

float g_fMainScale=0.05f;
float g_fMainOffset=1.f;

float Epsillon=0.01f;

sampler Sampler = sampler_state
{
    Texture   = (g_tEnvMap);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler SamplerDif = sampler_state
{
    Texture   = (g_tTex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};



float3 CalcVertex(float a, float b) //work out the position of the vertex using polar coordinates
{
	float sa, ca, sb, cb;
	
	sincos(a, sa, ca);
	sincos(b, sb, cb);
	
	float3 vert=float3(sa*cb, sa*sb, ca);

	float3 v=vert*g_f3DistortScale+g_f3DistortOffset;

	vert*=(g_fMainOffset+(cos(v.x)+cos(v.y)+cos(v.z))*g_fMainScale);
	
	return vert;
}

void VS(float3 Pos : POSITION, float2 UV : TEXCOORD0,
					out float4 oPos : POSITION, out float2 oUV : TEXCOORD0, out float4 oCol : COLOR, out float2 oUV2 : TEXCOORD1)
{
	float3 centre, up, down, left, right, Normal;
	
	centre	=CalcVertex(Pos.x, Pos.y);
	up		=CalcVertex(Pos.x, Pos.y-Epsillon);
	left	=CalcVertex(Pos.x-Epsillon, Pos.y);
	
	float4 Position=float4(centre, 1);
	Normal=normalize(cross(left-centre, up-centre));
	
	oPos=mul(Position, g_mWorldViewProj);
	float3 WNorm=mul(Normal, (float3x3)g_mWorld); //world space normal
	WNorm=normalize(WNorm);
	oUV=float2(WNorm.x*0.5-0.5, WNorm.y*0.5-0.5);
	oCol=dot(WNorm, float3(0, 0.5, -1))*float4(0.4, 0.4, 0.4, 1.0);
	
	oUV2=UV;
}

float4 PS(float4 Col : COLOR, float2 UVEnv: TEXCOORD0, float2 UVDif : TEXCOORD1) : COLOR
{
//	return tex2D(SamplerDif, UVDif)+Col;//Col+tex2D(Sampler, UVEnv)*1.25;
	return tex2D(SamplerDif, UVDif)*tex2D(Sampler, UVEnv)+Col;//Col+*1.25;
}

technique SphereDistort
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}