--- objective ---------------------------------------------------------
--
--    collect 1 star and return to the start area.
--    keep the front wheel up
--
-----------------------------------------------------------------------

app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\nightforest.png");
app:SetQueryUpdate(false);
SetLevelTime(180);

-- set bike position
bike = GetBike();
bike:MoveTo(750, 310);

AddObjective("collect 1 star and return to the start area");
AddObjective("keep the front wheel off the ground");

-- construct the level...
-- ...first create the starting area
space:Insert(CreateBlock(40, 400, 500, 100, "res\\brick500x100.png", false));
start_area = CreateBlock(540, 400, 400, 100, "res\\brick_start400x100.png", false);
space:Insert(start_area, "start_area");
space:Insert(CreateBlock(940, 400, 500, 100, "res\\brick500x100.png", false));

-- ...bridge
space:Insert(CreateLine(1440, 400, 1740, 261, "res\\wood330x15.png"));
space:Insert(CreateLine(1740, 261, 2040, 400, "res\\wood330x15.png"));

-- ...right side of the level
space:Insert(CreateBlock(2040, 400, 500, 100, "res\\brick500x100.png", false));

-- ...bottom of the bridge
space:Insert(CreateBlock(1240, 500, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateBlock(1740, 500, 500, 100, "res\\brick500x100.png", false));

-- ...add some dynamic objects under the bridge
space:Insert(CreateBlock(1650, 399, 10, 100, "res\\wood10x100.png", true));
space:Insert(CreateBlock(1750, 469, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1745, 453, 30, 15, "res\\brick30x15.png", true));
space:Insert(CreateBlock(1800, 469, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1795, 438, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1800, 407, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1890, 399, 10, 100, "res\\wood10x100.png", true));

-- ...create a block between bridge.
--    anchor the block so it can be detached later
block = CreateBlock(1735, 244, 10, 100, "res\\wood10x100.png", true);
RotateObject(block, 90);
AnchorAt(block, 1690, 286);
AnchorAt(block, 1790, 286);
block:SetMass(2);
space:Insert(block, 0, "piece_of_wood");

-- create events
-- detach the block between the bridge when the driver reaches x = 1450
driver = space:FindObject("driver");
EventXGreater(driver, 1450, "\
  s=app:GetSpace(); \
  o=space:FindObject(\"piece_of_wood\"); \
  o:RemoveUserJoint(0);");
EventXGreater(driver, 1650, "\
  s=app:GetSpace(); \
  o=space:FindObject(\"piece_of_wood\"); \
  o:RemoveUserJoint(0);");
-- end level if the player falls
EventYGreater(driver, 1500, "RestartLevel();");
-- end level if the front wheel collides (anything but the start area)
EventFrontWheelCollision(start_area, "RestartLevel();", true);

-- Add some spriders to make the level more scary ;)
spider = CreateSprite("res\\spider.png", 8, 64, 128, 24, 200, 400, 450, true);
space:Insert(spider);
spider = CreateSprite("res\\spider.png", 8, 64, 128, 24, 300, 1300, 450, true);
space:Insert(spider);

-- create 20 blinking stars to the sky
for i = 10, 30 do
  star = CreateSprite("res\\star.png", 15, 2, 2, 15, i*20, 0, 0, true);
  star:SetStatic(true);
  star:SetRandomPositioning(true, 800, 200);
  space:Insert(star, 1000, null);
end

-- add level stars
star = CreateLevelStar("star1", 2200, 340);
space:Insert(star);
level:Add(CreateVariableCondition("star1"));
level:Add(CreateVariableCondition("there_and_back_again"));

EventVariableTriggered("star1", 
  "EventRearWheelCollision(DefaultSpaceFind(\"start_area\"), \"SetVariable('there_and_back_again');\",true);");



