--- objective ---------------------------------------------------------
--
--    collect 3 stars
--
-----------------------------------------------------------------------

app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\planet.png");
app:SetQueryUpdate(false);

-- set bike position
bike = GetBike();
bike:MoveTo(1000, 400);

AddObjective("collect 3 stars");
SetLevelTime(300);

-- construct the level...
-- ...start area
space:Insert(CreateBlock(-24, -112, 64, 512, "res\\brick32x512.png", false));
space:Insert(CreateBlock(-24, -624, 64, 512, "res\\brick32x512.png", false));
space:Insert(CreateBlock(40, 400, 500, 100, "res\\brick500x100.png", false));

-- ...boost to up
space:Insert(CreateBoost("res\\boostarrow.png", 8, 32, 128, 16, 200.0, 40, 280, true, false, 2));

-- ...area between the start area and the ceiling
space:Insert(CreateBlock(700, -200, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateBlock(1200, -200, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateBlock(1770, -200, 20, 700, "res\\block20x700.png", false));
space:Insert(CreateBlock(1680, 0, 20, 500, "res\\block20x500.png", false));
space:Insert(CreateLine(1600, -200, 1705, -250, "res\\line117x3.png"));
space:Insert(CreateLine(1550, -1000, 2000, -756, "res\\line512x3.png"));

-- ...ceiling
space:Insert(CreateBlock(-200, -1000, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateBlock(300, -1000, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateBlock(800, -1000, 500, 100, "res\\brick500x100.png", false));

space:Insert(CreateLine(540, 400, 600, 500, "res\\line117x3.png"));
space:Insert(CreateBlock(700, 50, 256, 256, "res\\brick256x256.png", false));
space:Insert(CreateBlock(540, 500, 512, 64, "res\\brick512x64.png", false));
space:Insert(CreateBlock(1000, 468, 128, 32, "res\\blockblue128x32.png", false));
-- dy = 244, dx = 450 l = 512
space:Insert(CreateLine(1128, 468, 1578, 712, "res\\line512x3.png"));
space:Insert(CreateBlock(1578, 712, 256, 32, "res\\blockblue256x32.png", false));
-- dy = 270, dx = 435 l = 512
space:Insert(CreateLine(1834, 712, 2269, 442, "res\\line512x3.png"));

space:Insert(CreateBlock(2269, 442, 512, 32, "res\\blockblue512x32.png", false));
space:Insert(CreateBlock(2781, 442, 512, 32, "res\\blockblue512x32.png", false));

block = CreateBlock(3293, -38, 32, 512, "res\\brick32x512.png", false);
block:GetTexture():SetFlipHorizontally();
space:Insert(block);

-- create 20 blinking stars to the sky
for i = 10, 30 do
  star = CreateSprite("res\\star.png", 15, 2, 2, 15, i*20, 0, 0, true);
  star:SetStatic(true);
  star:SetRandomPositioning(true, 800, 600);
  space:Insert(star, 1000, null);
end

-- create some blue clouds
space:Insert(CreateCloud("res\\spacefog.png", 0.0, 0.5, 0, 0.5, 0.2));
space:Insert(CreateCloud("res\\spacefog.png", 0.0, -0.5, 0, 0.5, 0.6));
space:Insert(CreateCloud("res\\spacefog.png", 0.0, 0.2, 0, 0.5, 0.8));


bmp = CreateBitmap(540, 306, "res\\glass160x193.png");
space:Insert(bmp, -100, null);
bmp = CreateBitmap(700, 306, "res\\glass256x193.png");
space:Insert(bmp, -100, null);
bmp = CreateBitmap(956, 306, "res\\glass160x193cyan.png");
space:Insert(bmp, -100, null);

driver = space:FindObject("driver");
EventYGreater(driver, 1000, "RestartLevel();");

star1 = CreateLevelStar("star1", 1800, 300);
star2 = CreateLevelStar("star2", 720, -250);
star3 = CreateLevelStar("star3", 1900, -450);

space:Insert(star1);
space:Insert(star2);
space:Insert(star3);

level:Add(CreateVariableCondition("star1"));
level:Add(CreateVariableCondition("star2"));
level:Add(CreateVariableCondition("star3"));




