--- objective ---------------------------------------------------------
--
--    keep the front wheel up for 60 seconds
--
-----------------------------------------------------------------------

app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\city.png");
app:SetQueryUpdate(false);
SetLevelTime(180);

AddObjective("keep the front wheel off the ground for 30 seconds");

-- set bike position
bike = GetBike();
bike:MoveTo(150, 310);

-- construct the level...
space:Insert(CreateBlock(40, 400, 500, 100, "res\\brick500x100.png", false));

-- events
-- ...setup a timer. when the timer reaches zero the level is completed
RegisterTimerEvent("timer", 30, "SetVariable('completed');");
level:Add(CreateVariableCondition("completed"));

-- ...however, the timer is resetted if the front wheel touches the ground
EventFrontWheelCollision(null, "RestartTimer('timer');", false);

-- ...end level if the player falls
driver = space:FindObject("driver");
EventYGreater(driver, 550, "RestartLevel();");

