/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef DIRDATA_H
#define DIRDATA_H

#include <string>
#include <vector>

class DirData {
public:
	DirData(const std::string& levelDir);
	void scanDir(const std::string& levelDir);

	std::vector<std::string>& getBoards() {
		return m_boards;
	}
	std::vector<std::string>& getPacks() {
		return m_packs;
	}
	
private:
	std::string m_levelDir;
	std::vector<std::string> m_boards;
	std::vector<std::string> m_packs;
};

#endif
