/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef EVENTHANDLER_H
#define EVENTHANDLER_H

#include "SDL.h"

class Physics;
class Renderer;

class EventHandler {
public:
	EventHandler(Physics& physics, Renderer& graphics);

	enum State {
		NORMAL,
		QUIT,
		MENU,
		RESET
	};
	State processEvents();
	void resetMouse();
	
	void setMouseSensitivity(float sens) {
		if (sens)
			m_msensitivity = sens;
	}
	void setJoystickSensitivity(float sens) {
		if (sens)
			m_jsensitivity = sens;
	}
	float getMouseSens() {
		return m_msensitivity;
	}
	float getJoystickSens() {
		return m_jsensitivity;
	}
	void handleMouseMove(int x, int y);
	void handleClick() {
		if (m_grabMouse) {
//			if (!m_joystick)
//				SDL_ShowCursor(SDL_ENABLE);
			m_grabMouse = 0;
		} else {
//			if (!m_joystick)
//				SDL_ShowCursor(SDL_DISABLE);
			m_grabMouse = 1;
		}
	}

	
private:
	Physics& m_physics;
	Renderer& m_graphics;
	SDL_Joystick* m_joystick;
	float m_mouseX, m_mouseY;
	State m_retVal;
	float m_msensitivity;
	float m_jsensitivity;
	bool m_grabMouse;
	
	void handleEvent(SDL_Event& event);

	void keyDown(SDL_KeyboardEvent& e);
	void resize(SDL_ResizeEvent& e);
	void joyAxis(SDL_JoyAxisEvent& e);
	void mouseMove(SDL_MouseMotionEvent& e);
	void mousePress(SDL_MouseButtonEvent& e);
};

#endif
