/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef GAMELOOP_H
#define GAMELOOP_H

#include "physics.h"

class BoardTimes;
class Board;

class GameLoop {
public:
	GameLoop(const char* boardFile);
	GameLoop(Board& board);
	~GameLoop();

	/** Run the main loop until user quits or moves to next level.
	 * @param pack indicates whether we are playing a pack or a single board.
	 * @returns 0 if the board is quit
	 *          1 if the player wants to go the the next board
	 */
	bool start(bool pack=0);

	static void init();
	static void deInit();

private:
	Board& m_board;
	BoardTimes* m_times;
	bool m_next;
	bool m_freeBoard;

	bool handleMenu(Physics::UpdateState state, bool nextAvail);
};

#endif
