/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */
#ifndef LCD_H
#define LCD_H

enum LCDLine {
	UP=1,
	UP_LEFT=2,
	UP_MIDDLE=4,
	UP_RIGHT=8,
	MIDDLE_LEFT=16,
	MIDDLE_RIGHT=32,
	DOWN_LEFT=64,
	DOWN_MIDDLE=128,
	DOWN_RIGHT=256,
	DOWN=512,
	UP_BSLASH=1024,
	UP_SLASH=2048,
	DOWN_SLASH=4096,
	DOWN_BSLASH=8192
};

class LCD {
public:
	enum Alignment {
		LEFT, RIGHT, MIDDLE
	};
	
	static void load(const char* deffile) {
		m_instance.doLoad(deffile);
	}
	static int print(const char* str, Alignment align = LEFT) {
		return m_instance.doPrint(str, align);
	}
	
private:
	void print(LCDLine ch, float offset);
	int doPrint(const char* str, Alignment align);
	void doLoad(const char* deffile);
	void line(float x1, float y1, float x2, float y2);

	short alphabet['z'-'a'+1];
	short digits[10];

	static LCD m_instance;
	
	LCD() {}
	LCD(const LCD&) {}
	~LCD() {}
};

#endif
