#ifndef MAZEGEN_H
#define MAZEGEN_H

#include <boost/multi_array.hpp>

class ModifiableBoard;
class Board;
struct Wall;

class MazeGen {
public:
	MazeGen();
	~MazeGen();

	enum Algorithm {
		PRIM,
		DFS,
		KRUSKAL,
		CHAMBERS,
		NUM_ALGOS
	};
	Board& genMaze(int w, int h, Algorithm algo);
	
private:
	ModifiableBoard* m_board;

	void genPrim();
	void genDFS();
	void genKruskal();
	void genChambers();

	void recurseDFS(boost::multi_array_ref<bool, 2> cells, int x, int y);
	void recurseChambers(int sx, int sy, int ex, int ey);
	
	void fillWalls();
	void setStartEnd(int sx, int sy, int ex, int ey);

	bool wallExists(const Wall& w) const;
	void toggleBetween(int x1, int y1, int x2, int y2);

	template<class Iter>
	void addWalls(Iter i, int row, int col);
};

#endif
