#include "optionsmenu.h"
#include "lcd.h"
#include "menubg.h"
#include "glscreen.h"
#include "options.h"
#include "gameapp.h"
#include "sound.h"
#include "renderer.h"
#include "eventhandler.h"

OptionsMenu::OptionsMenu():
	m_fullscreen(GLScreen::isFullscreen()), m_music(Sound::getInstance().isEnabled()),
	m_turnBoard(GameApp::getInstance().getRenderer().turnBoard),
	m_topView(GameApp::getInstance().getRenderer().topView),
	m_msens(GameApp::getInstance().getEventHandler().getMouseSens()),
	m_jsens(GameApp::getInstance().getEventHandler().getJoystickSens())
{
	const std::vector<Coord<int> >& okRes = GLScreen::getOkRes();
	int resX = GLScreen::getResX();
	int resY = GLScreen::getResY();
	m_resolutions.setActive(-1);
	for(std::vector<Coord<int> >::const_iterator i=okRes.begin(); i!=okRes.end(); ++i) {
		std::ostringstream oss;
		oss << i->x << 'x' << i->y;
		m_resolutions.add(oss.str());
		if (i->x==resX && i->y==resY)
			m_resolutions.setActive(i-okRes.begin());
	}
	
	items.push_back(Item("fullscreen", &m_fullscreen));
	items.push_back(Item("resolution", &m_resolutions));
	items.push_back(Item("music", &m_music));
	items.push_back(Item("turn board", &m_turnBoard));
	items.push_back(Item("top view", &m_topView));
	items.push_back(Item("mouse sens", &m_msens));
	items.push_back(Item("aps sens", &m_jsens));
}

void OptionsMenu::exec()
{
	Base::Base::exec();
	
	if (GLScreen::updateRes(m_resolutions.getActive(), m_fullscreen.getValue())) {
		MenuBG::reloadTexture();
	}
	Sound::getInstance().setState(m_music.getValue());
	
	Renderer& rend = GameApp::getInstance().getRenderer();
	rend.turnBoard = m_turnBoard.getValue();
	rend.topView = m_topView.getValue();
	
	EventHandler& evt = GameApp::getInstance().getEventHandler();
	evt.setMouseSensitivity(m_msens.getValue());
	evt.setJoystickSensitivity(m_jsens.getValue());

	Options& opts = GameApp::getInstance().getOptions();
	using boost::lexical_cast;
	using std::string;
	opts["res_x"] = lexical_cast<string>(GLScreen::getResX());
	opts["res_y"] = lexical_cast<string>(GLScreen::getResY());
	opts["fullscreen"] = m_fullscreen.getValue() ? "1" : "0";
	opts["music"] = m_music.getValue() ? "1" : "0";
	opts["turnboard"] = m_turnBoard.getValue() ? "1" : "0";
	opts["topview"] = m_topView.getValue() ? "1" : "0";
	opts["msensitivity"] = lexical_cast<string>(m_msens.getValue());
	opts["jsensitivity"] = lexical_cast<string>(m_jsens.getValue());
	opts.write("kuula.cfg");
}

void OptionsMenu::draw()
{
	const float SCALE_FACTOR=0.05f;
	
	glLoadIdentity();
	MenuBG::draw();

	glTranslatef(-0.6, 0.85, 0);
	glScalef(SCALE_FACTOR, SCALE_FACTOR, SCALE_FACTOR);

	GLfloat hlColor[4] = {1,0,0,1};
	memcpy(menuitems::hlColor, hlColor, 4*sizeof(GLfloat));
	glPointSize(2);
	for(uint i=0; i<items.size(); ++i) {
		const char* const str = items[i].first.c_str();
		if (i == activeItem) {
			glColor3f(0.6, 1, 0.4);
			glLineWidth(3);
			LCD::print(str, LCD::RIGHT);
			glLineWidth(1);
		}
		glColor3f(0.8, 1, 0.1);
		LCD::print(str, LCD::RIGHT);

		glColor3f(0, 0.8, 0.1);
//		glSecondaryColor3f(1,0,0);
//		glPushMatrix();
		glTranslatef(1.5, 0, 0);
		items[i].second->draw();
		glTranslatef(-1.5, 0, 0);
//		glPopMatrix();
		
		glTranslatef(0, -1.4, 0);
	}
	glPointSize(1);
	
	SDL_GL_SwapBuffers();
}
