﻿import derelict.sdl.sdl;
import derelict.sdl.mixer;
import derelict.sdl.image;
import std.stdio;
import std.random;

const int resx = 1024;
const int resy = 768;
const int bpp = 32;

SDL_Event event;
SDL_Surface* screen;
bool run = true;

SDL_Surface* loadImage(char* filename)
{
    SDL_Surface* img = IMG_Load(filename);
    SDL_Surface* convimg = null;
    if(img != null)
    {
        convimg = SDL_DisplayFormat(img);
        SDL_FreeSurface(img); //Fria minnet.
    }
    return convimg; //Returna den processerade bilden.
}

void applySurface(int x, int y, SDL_Surface* source, SDL_Surface* dest)
{
    SDL_Rect offset;
    offset.x = x;
    offset.y = y;
    SDL_BlitSurface(source, null, dest, &offset);
}

class MadCow // I like them potatoes >__>
{
	private
	{
		SDL_Surface* gfx;
		int x, y, w, h;
	}
	public
	{
		this(int nx, int ny, char* ngfx)
		{
			x = nx;
			y = ny;
			w = 255;
			h = 191;
			gfx = loadImage(ngfx);
		}
		SDL_Surface* getGfx()
		{
			return gfx;
		}
		int getX()
		{
			return x;
		}
		int getY()
		{
			return y;
		}
		void move()
		{
			if(x >= resx)
			{
				int r = rand()%(resy-100) - h;
				
				if(r < 0)
					r = 0;
				
				y = r; // party!!!!
				x = 0-w;
			}
			else
				x += 2;
		}
	}
}

class NotMadCow
{
	private
	{
		SDL_Surface* gfx;
		int x, y, w, h;
	}
	public
	{
		this(int nx, int ny, char* ngfx)
		{
			x = nx;
			y = ny;
			w = 20000;
			h = 100;
			gfx = loadImage(ngfx);
		}
		SDL_Surface* getGfx()
		{
			return gfx;
		}
		int getX()
		{
			return x;
		}
		int getY()
		{
			return y;
		}
		void move()
		{
			x--;
		}
	}
}

class Screen
{
	private
	{
		SDL_Surface* screen;
	}
	public
	{
		this()
		{
			screen = SDL_SetVideoMode(resx, resy, bpp, SDL_FULLSCREEN | SDL_HWSURFACE | SDL_DOUBLEBUF); // Lol wtf?
			SDL_WM_SetCaption("Birdiepolka", null);
		}
		
		SDL_Surface* getScreen()
		{
			return screen;
		}
		
		void clear()
		{
			SDL_Rect offset;
			
			offset.x = 0;
			offset.y = 0;
			offset.w = resx;
			offset.h = resy;
			
			Uint32 color = SDL_MapRGB(screen.format,0,0,0);
			SDL_FillRect(screen, &offset, color);
		}
	}
}

void quit()
{
	run = false;
	SDL_Quit();
	DerelictSDL.unload();
	Mix_CloseAudio();
	DerelictSDLImage.unload();
	DerelictSDLMixer.unload();
}

int main()
{
	int audio_rate = 22050;
	Uint16 audio_format = AUDIO_S16SYS;
	int audio_channels = 2;
	int audio_buffers = 4096;

	DerelictSDL.load();
	DerelictSDLImage.load();
	DerelictSDLMixer.load();
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) != 0)
	{
		writef("Unable to initialize SDL: %s\n", SDL_GetError());
		run = false;
	}
	 
	if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) != 0)
	{
		writef("Unable to initialize audio: %s\n", Mix_GetError());
		run = false;
	}
	
    Screen Flurry = new Screen;
	SDL_ShowCursor(SDL_DISABLE);
	MadCow Cow = new MadCow(10,193,"galen.png");
	NotMadCow Sven = new NotMadCow(resx,resy-75,"text.png");
	Mix_Music* music = Mix_LoadMUS("folkdans.ogg");
	if(music == null) 
	{
		writef("Unable to load Ogg file: %s\n", Mix_GetError());
		return 1;
	}
	if(Mix_PlayMusic(music, 0) == -1) 
	{
		writef("Unable to play Ogg file: %s\n", Mix_GetError());
		return 1;
	}
	int start = SDL_GetTicks();
    while(SDL_GetTicks() - start < 104000)
	{
		//Controls start
        while (SDL_PollEvent(&event))
		{
            switch (event.type)
			{
                case SDL_QUIT:
					Mix_HaltMusic();
					Mix_FreeMusic(music);
					quit(); goto hejdao;
					break;
                default:
                    break;
            }
			switch (event.key.keysym.sym)
			{
				case SDLK_ESCAPE:
					Mix_HaltMusic();
					Mix_FreeMusic(music);
					quit(); goto hejdao;
					break;
				default:
					break;
			}
        }
		//Controls end
		//Drawing start
		Cow.move();
		Sven.move();
		Flurry.clear();
		applySurface(Cow.getX(),Cow.getY(),Cow.getGfx(),Flurry.getScreen());
		applySurface(Sven.getX(),Sven.getY(),Sven.getGfx(),Flurry.getScreen());
		SDL_Flip(Flurry.getScreen());
		SDL_Delay(1);
		//Drawing end
    }

hejdao:
	return 0;
}