
uniform float time;
uniform float riverness;
varying float depth;

#define BSIZE 32
#define FULLSIZE 66
#define NOISEFRAC 0.03125




// this is the smoothstep function f(t) = 3t^2 - 2t^3, without the normalization
vec3 s_curve(vec3 t) { return t*t*( vec3(3,3,3) - vec3(2,2,2)*t); }
vec2 s_curve(vec2 t) { return t*t*( vec2(3,3) - vec2(2,2)*t); }
float  s_curve(float  t) { return t*t*(3.0-2.0*t); }





float noise(vec2 pos, float t){	
	float n=0;
	n+=sin(pos.t*0.48+t*0.231);
	n+=cos(pos.s+t*0.12)+sin(pos.t+t*0.231);
	n+=0.6*cos((pos.s*-1.59-t*0.129932) + t*0.132)+0.6*sin( (pos.t*1.923183+t*0.02231) );
	n+=0.1*(cos((pos.t*-3.859+t*0.9932))+sin( (-pos.s*3.191183+t*11.23821717) ));
	
    return n; 
}

void main()
{

	depth = -(gl_ModelViewMatrix * gl_Vertex).z;
	gl_TexCoord[2] = gl_MultiTexCoord0+vec4(0,max(time*-0.2+1.0,-1.0f),0,0);

	gl_TexCoord[0] = gl_MultiTexCoord0;
	vec2 offset = vec2(0.0,0.09321)*time;
	
	vec4 p = gl_Vertex;
	vec2 pos = gl_TexCoord[0].st;
	
	pos += offset;
	
	gl_TexCoord[0]=vec4(pos,0,0);
	
	float n = noise(pos*15.0,pos.t);
	
	float dist=abs(gl_MultiTexCoord0.s-0.5)*2.0;
	
	float howmuch = min(70.0* pow(dist+0.2,5.0) +0.2, 1.0);
	
	float factor = mix(1.0,howmuch,riverness);
		
	n/=8.4;	
		
	p.y += abs(n)*100.0*factor;
	//p.y *= 20.0;
	

	
		
		
	gl_Position = gl_ModelViewProjectionMatrix*p;
}