uniform sampler2D colorMap;		//vanliga scenen
uniform sampler2D normalMap;	//blurrad scen
uniform sampler2D heightMap;	//djup-blur-sak textur frn DOF-passet

#define NUM_TAPS 8

vec2 poisson[8] = vec2[8](
							vec2(0.0, 0.0),
							vec2( 0.527837,-0.085868),
							vec2(-0.040088, 0.536087),
							vec2(-0.670445,-0.179949),
							vec2(-0.419418,-0.616039),
							vec2( 0.440453,-0.639399),
							vec2(-0.757088, 0.349334),
							vec2( 0.574619, 0.685879));
							
vec2 vMaxCoC = vec2(1.0, 2.0); // 5 7 // 5 10

vec2 pixelSizeHigh = vec2(1.0 / 1024.0, 1.0 / 768.0);
vec2 pixelSizeLow = vec2(1.0 / 1024.0, 1.0 / 768.0)*4;

float radiusScale = 0.8; //0.4

void main()
{
	vec2 texCoord = gl_TexCoord[0].st;
	vec4 cOut;
	float discRadius, discRadiusLow, centerDepth;
	
	centerDepth = texture2D(heightMap, texCoord).r;              // save its depth

	// convert depth into blur radius in pixels
	discRadius = abs(centerDepth * vMaxCoC.y - vMaxCoC.x);

	// compute disc radius on low-res image
	discRadiusLow = discRadius * radiusScale;

	// reuse cOut as an accumulator
	cOut = vec4(0);

	for(int t = 0; t < NUM_TAPS; t++)
	{
		// fetch low-res tap
		vec2 coordLow = texCoord + (pixelSizeLow * poisson[t] *  discRadiusLow);
		vec4 tapLow = texture2D(normalMap, coordLow);

		// fetch high-res tap
		vec2 coordHigh = texCoord + (pixelSizeHigh * poisson[t] * discRadius);
		vec4 tapHigh = texture2D(colorMap, coordHigh);
		tapHigh.a = texture2D(heightMap, coordHigh).r;
		// put tap blurriness into [0, 1] range
		float tapBlur = abs(tapHigh.a * 2.0 - 1.0);

		// mix low- and hi-res taps based on tap blurriness
		vec4 tap = mix(tapHigh, tapLow, tapBlur);

		// apply leaking reduction: lower weight for taps that are
		// closer than the center tap and in focus
		tap.a = (tap.a >= centerDepth) ? 1.0 : abs(tap.a * 2.0 - 1.0);

		// accumulate
		cOut.rgb += tap.rgb * tap.a;
		cOut.a += tap.a;
	}

	// normalize and return result
	gl_FragColor = cOut / cOut.a;
}

