#!/bin/sh
#
# This script creates the Makefile.am file, for use with automake.
# It requires a working printf(1).
#

self=`basename $0`

# Collect header files.
files=`ls *.h|sed -e '/Config.h/d'`
if [ -z "$files" ]; then
  echo "$self: No header files; punting"
  exit 1
fi

rm -f Makefile.am

echo "# Generated by $self." >> Makefile.am
echo '# DO NOT EDIT THIS FILE!' >> Makefile.am
echo >> Makefile.am

# Rule for non-distribution of configuration header.
echo 'nodist_pkginclude_HEADERS = Config.h' >> Makefile.am
echo >> Makefile.am

# Rule for installing headers.

echo -n "pkginclude_HEADERS =" >> Makefile.am

for file in $files; do
  if [ "$file" != 'Wendy.h' ]; then
    if [ -z "`grep \"$file\" Wendy.h`" ]; then
      echo "$file: warning; header not included by Wendy.h"
    fi
  fi
  echo -n " $file" >> Makefile.am
done
echo >> Makefile.am
echo >> Makefile.am

# Rule for building configuration header.
printf 'Config.h: @top_srcdir@/include/config.h\n' >> Makefile.am
printf '\t@top_srcdir@/build/makeconfig.sh \$< \$@\n' >> Makefile.am
echo >> Makefile.am

# Rule for redistributing self.
echo "EXTRA_DIST = $self" >> Makefile.am
echo >> Makefile.am

