// Species of Automatic Treatment - A demo for Birdie 17
// Copyright (c) 2007 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.

#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"
#include "Stars.h"
#include "Water.h"
#include "Credits.h"
#include "Hyper.h"
#include "Greets.h"
#include "Frame.h"
#include "Noise.h"
#include "Title.h"
#include "Planet.h"
#include "Connect.h"
#include "Scroll.h"
#include "Sound.h"
#include "Demo.h"

#include <time.h>

Demo::Demo(void)
{
}

Demo::~Demo(void)
{
  shutdownSound();

  demo::Editor::destroy();
  UI::Renderer::destroy();
  GL::Renderer::destroy();
  GL::Context::destroy();
}

bool Demo::init(void)
{
  srand(time(NULL));

  Mesh::addSearchPath(Path("data/meshes"));
  Image::addSearchPath(Path("data/textures"));
  Font::addSearchPath(Path("data/fonts"));
  GL::ShaderProgram::addSearchPath(Path("data/shaders"));
  GL::VertexShader::addSearchPath(Path("data/shaders"));
  GL::FragmentShader::addSearchPath(Path("data/shaders"));
  render::Style::addSearchPath(Path("data/shaders"));
  render::Terrain::addSearchPath(Path("data/terrain"));
  demo::Show::addSearchPath(Path("data"));

  GL::ContextMode mode(800, 600, 32, 32, 0, 0, 0);
  if (!GL::Context::create(mode))
    return false;

  if (!GL::Renderer::create())
    return false;

  new demo::EffectTemplate<TitleEffect>("Demo title");
  new demo::EffectTemplate<NoiseEffect>("TV noise");
  new demo::EffectTemplate<HyperEffect>("HyperCube");
  new demo::EffectTemplate<FrameEffect>("Laser screen");
  new demo::EffectTemplate<GreetsEffect>("Greets");
  new demo::EffectTemplate<CreditsEffect>("Credits");
  new demo::EffectTemplate<PlanetEffect>("Planet");
  new demo::EffectTemplate<ConnectEffect>("Connect");
  new demo::EffectTemplate<ScrollEffect>("Scroll");

  if (!UI::Renderer::create())
    return false;

  if (!demo::Editor::create("demo"))
    return false;

  if (!initializeSound())
    Log::writeWarning("Running without sound");

  return true;
}

int main()
{
  if (!wendy::initialize())
    exit(1);

  Ptr<Demo> demo = new Demo();
  if (!demo->init())
  {
    wendy::shutdown();
    exit(1);
  }

  demo::Editor::get()->run();

  demo = NULL;

  wendy::shutdown();
  exit(0);
}

