
#include <wendy/Wendy.h>

#include <fmod.h>

using namespace moira;
using namespace wendy;

namespace
{

FSOUND_STREAM* stream = NULL;
int channel = -1;

void onPaused(void)
{
  FSOUND_SetPaused(channel, 1);
}

void onResumed(void)
{
  FSOUND_SetPaused(channel, 0);
}

void onTimeChanged(void)
{
  demo::Editor* editor = demo::Editor::get();

  FSOUND_Stream_SetTime(stream, (int) (editor->getTimeElapsed() * 1000));
}

}

bool initializeSound(void)
{
  if (!FSOUND_Init(44100, 32, FSOUND_INIT_GLOBALFOCUS))
    return false;

  demo::Editor* editor = demo::Editor::get();

  String path = editor->getShow().getMusicPath().asString();
  if (!path.empty())
  {
    stream = FSOUND_Stream_Open(path.c_str(), FSOUND_2D, 0, 0);
    if (!stream)
      return false;

    channel = FSOUND_Stream_Play(FSOUND_FREE, stream);
    if (channel == -1)
      return false;

    editor->getPausedSignal().connect(onPaused);
    editor->getResumedSignal().connect(onResumed);
    editor->getTimeChangedSignal().connect(onTimeChanged);
  }

  return true;
}

void shutdownSound(void)
{
  if (stream)
  {
    if (channel != -1)
      FSOUND_Stream_Stop(stream);

    FSOUND_Stream_Close(stream);
    stream = NULL;
  }

  FSOUND_Close();
}

