
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Scroll.h"

#include <sstream>

ScrollEffect::ScrollEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name)
{
}

void ScrollEffect::update(Time deltaTime)
{
}

bool ScrollEffect::init(void)
{
  for (unsigned int i = 0;  i < 5;  i++)
  {
    std::stringstream name;
    name << "scroller" << i;

    textTextures[i] = GL::Texture::readInstance(name.str());
    if (!textTextures[i])
      return false;

    textStyles[i] = new render::Style();
    render::Technique& textTechnique = textStyles[i]->createTechnique();
    GL::Pass& textPass = textTechnique.createPass();
    GL::TextureLayer& textLayer = textPass.createTextureLayer();
    textLayer.setTexture(textTextures[i]);
    textLayer.setAddressMode(GL_CLAMP_TO_EDGE);
  }

  return true;
}

void ScrollEffect::render(void) const
{
  renderChildren();

  GL::Canvas* canvas = GL::Canvas::getCurrent();
  canvas->clearDepthBuffer();
  canvas->clearColorBuffer(ColorRGBA::BLACK);

  GL::Renderer* renderer = GL::Renderer::get();
  renderer->begin2D(Vector2(4.f / 3.f, 1.f));

  for (unsigned int i = 0;  i < 5;  i++)
  {
    const GL::Texture* texture = textTextures[i];
    const render::Style* style = textStyles[i];

    const float t = 5.f * getTimeElapsed() / getDuration();
    float position = t - i * 0.8f - 0.5f;

    render::Sprite2 sprite;

    sprite.size.set(0.8f * 4.f / 3.f, 0.8f * 4.f / 3.f * texture->getHeight() / (float) texture->getWidth());
    sprite.position.set(2.f / 3.f, position);
    sprite.render(*style);
  }

  renderer->end();
}

