
class Water : public render::Renderable, public RefObject<Water>
{
public:
  void prepare(render::Queue& queue) const;
  void enqueue(render::Queue& queue, const Transform3& transform) const;
  const Sphere& getBounds(void) const;
  static Water* createInstance(float radius);
private:
  Water(void);
  bool init(float radius);
  Ref<render::Style> style;
  Ptr<GL::TextureCanvas> canvas;
  Sphere bounds;
};

class WaterNode : public render::SceneNode
{
public:
  void setWater(Water* newWater);
protected:
  void enqueue(render::Queue& queue, render::QueuePhase phase) const;
private:
  Ref<Water> water;
};

