///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_ANIMATION_H
#define MOIRA_ANIMATION_H
///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

/*! @brief Keyframe animation track.
 */
class Animation : public Resource<Animation>
{
public:
  /*! Default constructor.
   */
  Animation(const String& name = "");
  /*! Calculates the transformation at the specified time.
   *  @remarks The time value is clamped to the range [0, duration].
   */
  void evaluate(Time time, Transform3& transform);
  /*! The duration, in seconds, of this animation.
   */
  Time duration;
  BezierTrack3 positions;
  QuaternionTrack rotations;
};

///////////////////////////////////////////////////////////////////////

typedef ResourceCodec<Animation> AnimationCodec;

///////////////////////////////////////////////////////////////////////

class AnimationCodecXML : public AnimationCodec, public XML::Codec
{
public:
  Animation* read(const Path& path, const String& name = "");
  Animation* read(Stream& stream, const String& name = "");
  bool write(const Path& path, const Animation& animation);
  bool write(Stream& stream, const Animation& animation);
private:
  bool onBeginElement(const String& name);
  bool onEndElement(const String& name);
  Ptr<Animation> animation;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_ANIMATION_H*/
///////////////////////////////////////////////////////////////////////
