///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2006 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_FORMAT_H
#define MOIRA_FORMAT_H
///////////////////////////////////////////////////////////////////////

#include <vector>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

class FormatComponent
{
public:
  enum Type
  {
    INT8,
    INT16,
    INT32,
    INT64,
    UINT8,
    UINT16,
    UINT32,
    UINT64,
    FLOAT,
    DOUBLE,
    CHAR,
  };
  FormatComponent(const String& name, Type type, unsigned int count = 1);
  const String& getName(void) const;
  Type getType(void) const;
  size_t getOffset(void) const;
  unsigned int getCount(void) const;
private:
  String name;
  Type type;
  unsigned int count;
};

///////////////////////////////////////////////////////////////////////

class Format
{
public:
  void addComponent(const FormatComponent& component);
  void removeComponents(void);
  const FormatComponent* findComponent(const String& name) const;
  const FormatComponent* getComponent(unsigned int index) const;
  unsigned int getComponentCount(void) const;
private:
  typedef std::vector<FormatComponent> ComponentList;
  ComponentList components;
};

///////////////////////////////////////////////////////////////////////

class FormatCodec
{
public:
  FormatCodec(const Format& format);
private:
  const Format& format;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_FORMAT_H*/
///////////////////////////////////////////////////////////////////////
