///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_PORTABILITY_H
#define MOIRA_PORTABILITY_H
///////////////////////////////////////////////////////////////////////

#if MOIRA_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if MOIRA_HAVE_STDARG_H
#include <stdarg.h>
#endif

#if _WIN32

/* Don't consider the libc obsolete */
#pragma warning( disable: 4996 )

#define _USE_MATH_DEFINES

#define access _access
#define vsnprintf _vsnprintf
#define snprintf _snprintf
#define dup _dup
#define close _close
#define strcasecmp stricmp

#define F_OK 0
#define W_OK 2
#define R_OK 4

#define S_ISDIR(x) ((x) & _S_IFDIR)
#define S_ISREG(x) ((x) & _S_IFREG)

float fminf(float x, float y);
float fmaxf(float x, float y);
float log2f(float x);

#endif /*_WIN32*/

#if !MOIRA_HAVE_VASPRINTF
int vasprintf(char** result, const char* format, va_list vl);
#endif /*HAVE_VASPRINTF*/

#if !MOIRA_HAVE_STRTOF
float strtof(const char* nptr, char** endptr);
#endif /*HAVE_STRTOF*/

#if !MOIRA_HAVE_SOCKLEN_T
/*typedef int socklen_t;*/
#endif /*HAVE_SOCKLEN_T*/

#if !MOIRA_HAVE_STRLCAT
size_t strlcat(char* target, const char* source, size_t size);
#endif /*HAVE_STRLCAT*/

#if !MOIRA_HAVE_STRLCPY
size_t strlcpy(char* target, const char* source, size_t size);
#endif /*HAVE_STRLCPY*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_PORTABILITY_H*/
///////////////////////////////////////////////////////////////////////
