/*
 * Decompiled with CFR 0.152.
 */
package demox;

import demox.DemoPanel;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Main {
    public static void main(String[] args) {
        boolean fullscreen = false;
        boolean musicOnOff = true;
        boolean askconfig = true;
        int bitdepth = 32;
        for (int a = 0; a < args.length; ++a) {
            if (args[a].equalsIgnoreCase("-nofullscreen")) {
                fullscreen = false;
            }
            if (args[a].equalsIgnoreCase("-windowed")) {
                fullscreen = false;
            }
            if (args[a].equalsIgnoreCase("-fullscreen")) {
                fullscreen = true;
            }
            if (args[a].equalsIgnoreCase("-24bit")) {
                bitdepth = 24;
            }
            if (args[a].equalsIgnoreCase("-16bit")) {
                bitdepth = 16;
            }
            if (args[a].equalsIgnoreCase("-8bit")) {
                bitdepth = 8;
            }
            if (args[a].equalsIgnoreCase("-mute")) {
                musicOnOff = false;
            }
            if (!args[a].equalsIgnoreCase("-nosound")) continue;
            musicOnOff = false;
        }
        if (askconfig) {
            int question = JOptionPane.showConfirmDialog(null, "Fullscreen?");
            if (question == 0) {
                fullscreen = true;
            }
            if (question == 1) {
                fullscreen = false;
            }
        }
        System.out.println("gfx settings: bitdepth:" + bitdepth + " fullscreen:" + fullscreen);
        JFrame frame = new JFrame();
        frame.setTitle("demox");
        frame.setResizable(false);
        DemoPanel panel = new DemoPanel(musicOnOff);
        frame.getContentPane().add(panel);
        frame.setDefaultCloseOperation(3);
        if (!fullscreen) {
            frame.setSize(640, 502);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int w = frame.getSize().width;
            int h = frame.getSize().height;
            int x = (dim.width - w) / 2;
            int y = (dim.height - h) / 2;
            frame.setLocation(x, y);
        }
        if (fullscreen) {
            frame.setUndecorated(true);
            frame.setSize(640, 480);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            gs.setFullScreenWindow(frame);
            DisplayMode displayMode = gs.getDisplayMode();
            displayMode = new DisplayMode(640, 480, bitdepth, displayMode.getRefreshRate());
            try {
                gs.setDisplayMode(displayMode);
            }
            catch (Exception e) {
                gs.setFullScreenWindow(null);
                System.out.println("graffamoodi=fail");
            }
        }
        frame.setVisible(true);
    }
}

