/*
 * Decompiled with CFR 0.152.
 */
package demox;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class porno {
    double fps;
    int lastframe;
    String zip;
    String name;
    public int[] src4 = new int[16261];
    public int[] src3 = new int[16261];
    public int[] src2 = new int[16261];
    public int[] src = new int[16261];
    int framecount;
    int frameoffset;
    int timeoffset;
    int[] noisemap;
    static int w = 161;
    static int h = 101;
    public boolean motionblur = false;

    public porno(String videofile, double speed, int numberofframes, String videoname) {
        this.fps = speed;
        this.zip = videofile;
        this.framecount = numberofframes;
        this.name = videoname;
        this.frameoffset = 0;
        this.timeoffset = 0;
    }

    public int[] loadVideoFrame(String file) {
        BufferedImage img;
        try {
            ZipFile zippi = new ZipFile(this.zip);
            ZipEntry zipentry = zippi.getEntry(file);
            InputStream in = zippi.getInputStream(zipentry);
            img = ImageIO.read(in);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        int width = ((Image)img).getWidth(null);
        int height = ((Image)img).getHeight(null);
        if (width <= 0 || height <= 0) {
            // empty if block
        }
        int[] pixels = new int[width * height];
        PixelGrabber grab = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        try {
            grab.grabPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        return pixels;
    }

    public void render(int[] dest) {
        for (int j = 0; j < 100; ++j) {
            for (int i = 0; i < 160; ++i) {
                int c3 = this.src[i + (1 + j) * 161];
                int c4 = this.src[i + j * 161];
                int c5 = this.src[1 + i + (1 + j) * 161];
                int c6 = this.src[1 + i + j * 161];
                int rdif1 = (c3 >> 16 & 0xFF) - (c4 >> 16 & 0xFF) << 14;
                int r1 = (c4 >> 16 & 0xFF) << 16;
                int gdif1 = (c3 >> 8 & 0xFF) - (c4 >> 8 & 0xFF) << 14;
                int g1 = (c4 >> 8 & 0xFF) << 16;
                int bdif1 = (c3 & 0xFF) - (c4 & 0xFF) << 14;
                int b1 = (c4 & 0xFF) << 16;
                int rdif2 = (c5 >> 16 & 0xFF) - (c6 >> 16 & 0xFF) << 14;
                int r2 = (c6 >> 16 & 0xFF) << 16;
                int gdif2 = (c5 >> 8 & 0xFF) - (c6 >> 8 & 0xFF) << 14;
                int g2 = (c6 >> 8 & 0xFF) << 16;
                int bdif2 = (c5 & 0xFF) - (c6 & 0xFF) << 14;
                int b2 = (c6 & 0xFF) << 16;
                for (int y = (j << 2) * 640 + (i << 2); y < (4 + (j << 2)) * 640 + (i << 2); y += 640) {
                    int c2 = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16;
                    r1 += rdif1;
                    g1 += gdif1;
                    b1 += bdif1;
                    int c1 = r2 & 0xFF0000 | g2 >> 8 & 0xFF00 | b2 >> 16;
                    r2 += rdif2;
                    g2 += gdif2;
                    b2 += bdif2;
                    int rdif = (c1 >> 16 & 0xFF) - (c2 >> 16 & 0xFF) << 14;
                    int r = (c2 >> 16 & 0xFF) << 16;
                    int gdif = (c1 >> 8 & 0xFF) - (c2 >> 8 & 0xFF) << 14;
                    int g = (c2 >> 8 & 0xFF) << 16;
                    int bdif = (c1 & 0xFF) - (c2 & 0xFF) << 14;
                    int b = (c2 & 0xFF) << 16;
                    for (int x = y; x < y + 4; ++x) {
                        dest[x] = r & 0xFF0000 | g >> 8 & 0xFF00 | b >> 16;
                        r += rdif;
                        g += gdif;
                        b += bdif;
                    }
                }
            }
        }
    }

    public void render(int noiseamount, int[] dest) {
        int amount = noiseamount + (int)(Math.random() * 8.0 - 4.0);
        if (amount > 255) {
            amount = 255;
        }
        int p = amount;
        int p2 = 255 - amount;
        int z = (int)(Math.random() * 65535.0) + amount * 232151 & 0xFFFF;
        for (int j = 0; j < 100; ++j) {
            for (int i = 0; i < 160; ++i) {
                int c3 = this.src[i + (1 + j) * 161];
                int c4 = this.src[i + j * 161];
                int c5 = this.src[1 + i + (1 + j) * 161];
                int c6 = this.src[1 + i + j * 161];
                int rdif1 = (c3 >> 16 & 0xFF) - (c4 >> 16 & 0xFF) << 14;
                int r1 = (c4 >> 16 & 0xFF) << 16;
                int gdif1 = (c3 >> 8 & 0xFF) - (c4 >> 8 & 0xFF) << 14;
                int g1 = (c4 >> 8 & 0xFF) << 16;
                int bdif1 = (c3 & 0xFF) - (c4 & 0xFF) << 14;
                int b1 = (c4 & 0xFF) << 16;
                int rdif2 = (c5 >> 16 & 0xFF) - (c6 >> 16 & 0xFF) << 14;
                int r2 = (c6 >> 16 & 0xFF) << 16;
                int gdif2 = (c5 >> 8 & 0xFF) - (c6 >> 8 & 0xFF) << 14;
                int g2 = (c6 >> 8 & 0xFF) << 16;
                int bdif2 = (c5 & 0xFF) - (c6 & 0xFF) << 14;
                int b2 = (c6 & 0xFF) << 16;
                for (int y = (j << 2) * 640 + (i << 2); y < (4 + (j << 2)) * 640 + (i << 2); y += 640) {
                    int c2 = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16;
                    r1 += rdif1;
                    g1 += gdif1;
                    b1 += bdif1;
                    int c1 = r2 & 0xFF0000 | g2 >> 8 & 0xFF00 | b2 >> 16;
                    r2 += rdif2;
                    g2 += gdif2;
                    b2 += bdif2;
                    int rdif = (c1 >> 16 & 0xFF) - (c2 >> 16 & 0xFF) << 14;
                    int r = (c2 >> 16 & 0xFF) << 16;
                    int gdif = (c1 >> 8 & 0xFF) - (c2 >> 8 & 0xFF) << 14;
                    int g = (c2 >> 8 & 0xFF) << 16;
                    int bdif = (c1 & 0xFF) - (c2 & 0xFF) << 14;
                    int b = (c2 & 0xFF) << 16;
                    for (int x = y; x < y + 4; ++x) {
                        int c7 = r & 0xFF0000 | g >> 8 & 0xFF00 | b >> 16;
                        int c8 = p * this.noisemap[++z & 0xFFFF] >> 8;
                        dest[x] = (p2 * (c7 & 0xFF00FF) >> 8 & 0xFF00FF) + (c8 << 16 | c8) | ((c7 & 0xFF00) * p2 >> 8 & 0xFF00) + (c8 << 8);
                        r += rdif;
                        g += gdif;
                        b += bdif;
                    }
                }
            }
        }
    }

    public void readframe(int time) {
        int frame = (int)((double)(time - this.timeoffset) / 1000.0 * this.fps + (double)this.frameoffset) % this.framecount + 1;
        if (frame != this.lastframe) {
            String nollat = "";
            if (this.framecount < 100 && Integer.toString(frame).length() == 1) {
                nollat = "0";
            }
            if (this.framecount > 99 & this.framecount < 1000) {
                if (Integer.toString(frame).length() == 1) {
                    nollat = "00";
                }
                if (Integer.toString(frame).length() == 2) {
                    nollat = "0";
                }
            }
            if (this.framecount > 999) {
                if (Integer.toString(frame).length() == 1) {
                    nollat = "000";
                }
                if (Integer.toString(frame).length() == 2) {
                    nollat = "00";
                }
                if (Integer.toString(frame).length() == 3) {
                    nollat = "0";
                }
            }
            this.lastframe = frame;
            this.src2 = this.loadVideoFrame(this.name + nollat + Integer.toString(frame) + ".jpg");
        }
        if (this.motionblur) {
            this.blendAvg(this.src2, this.src3, this.src3);
            System.arraycopy(this.src3, 0, this.src, 0, this.src3.length);
        } else {
            System.arraycopy(this.src2, 0, this.src, 0, this.src2.length);
        }
    }

    public void jumptoframe(int time, int frame) {
        this.timeoffset = time;
        this.frameoffset = frame;
    }

    public void blendAvg(int[] to, int[] from, int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int c1 = from[i];
            int c2 = to[i];
            dest[i] = ((c1 & 0xFF00FF) >> 1 & 0xFF00FF) + ((c2 & 0xFF00FF) >> 1 & 0xFF00FF) | ((c1 & 0xFF00) >> 1 & 0xFF00) + ((c2 & 0xFF00) >> 1 & 0xFF00);
        }
    }

    public void sharpen() {
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        for (int i = 0; i < this.src.length - 1; ++i) {
            int c = this.src[i];
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            int a1 = (r << 1) - r2;
            int a2 = (g << 1) - g2;
            int a3 = (b << 1) - b2;
            if (a1 > 255) {
                a1 = 255;
            }
            if (a2 > 255) {
                a2 = 255;
            }
            if (a3 > 255) {
                a3 = 255;
            }
            if (a1 < 0) {
                a1 = 0;
            }
            if (a2 < 0) {
                a2 = 0;
            }
            if (a3 < 0) {
                a3 = 0;
            }
            this.src[i] = a1 << 16 | a2 << 8 | a3;
            int c2 = this.src[++i];
            r2 = c2 >> 16 & 0xFF;
            g2 = c2 >> 8 & 0xFF;
            b2 = c2 & 0xFF;
            a1 = (r2 << 1) - r;
            a2 = (g2 << 1) - g;
            a3 = (b2 << 1) - b;
            if (a1 > 255) {
                a1 = 255;
            }
            if (a2 > 255) {
                a2 = 255;
            }
            if (a3 > 255) {
                a3 = 255;
            }
            if (a1 < 0) {
                a1 = 0;
            }
            if (a2 < 0) {
                a2 = 0;
            }
            if (a3 < 0) {
                a3 = 0;
            }
            this.src[i] = a1 << 16 | a2 << 8 | a3;
        }
    }

    public void blur(int s) {
        this.hblur(s, this.src, this.src3);
        this.vblur(s, this.src3, this.src);
    }

    public void glow(int s) {
        this.hblur(s, this.src, this.src3);
        this.vblur(s, this.src3, this.src4);
        this.blendAdd(this.src, this.src4, this.src);
    }

    public void hblur(int s, int[] src, int[] dest) {
        int r = 0;
        int g = 0;
        int b = 0;
        int osa = (int)(1.0 / (2.0 * (double)s) * 65536.0);
        int s2 = s * w;
        if (s > 0) {
            for (int y = 0; y < h; ++y) {
                int c2;
                int c;
                int x;
                r = 0;
                g = 0;
                b = 0;
                int kohta = y * w;
                for (x = 0; x < s; ++x) {
                    c = src[kohta];
                    r += c >> 16 & 0xFF;
                    g += c >> 8 & 0xFF;
                    b += c & 0xFF;
                    ++kohta;
                }
                kohta = y * w;
                for (x = 0; x < s; ++x) {
                    c = src[kohta + s];
                    dest[kohta] = (r += c >> 16 & 0xFF) * osa & 0xFF0000 | (g += c >> 8 & 0xFF) * osa >> 8 & 0xFF00 | (b += c & 0xFF) * osa >> 16;
                    ++kohta;
                }
                for (x = s; x < w - s; ++x) {
                    c = src[kohta + s];
                    c2 = src[kohta - s];
                    r += c >> 16 & 0xFF;
                    g += c >> 8 & 0xFF;
                    b += c & 0xFF;
                    dest[kohta] = (r -= c2 >> 16 & 0xFF) * osa & 0xFF0000 | (g -= c2 >> 8 & 0xFF) * osa >> 8 & 0xFF00 | (b -= c2 & 0xFF) * osa >> 16;
                    ++kohta;
                }
                for (x = w - s; x < w; ++x) {
                    c2 = src[kohta - s];
                    dest[kohta] = (r -= c2 >> 16 & 0xFF) * osa & 0xFF0000 | (g -= c2 >> 8 & 0xFF) * osa >> 8 & 0xFF00 | (b -= c2 & 0xFF) * osa >> 16;
                    ++kohta;
                }
            }
        }
    }

    public void vblur(int s, int[] src, int[] dest) {
        int r = 0;
        int g = 0;
        int b = 0;
        int osa = (int)(1.0 / (2.0 * (double)s) * 65536.0);
        int s2 = s * w;
        if (s > 0) {
            for (int x = 0; x < w; ++x) {
                int c2;
                int c;
                int y;
                r = 0;
                g = 0;
                b = 0;
                int kohta = x;
                for (y = 0; y < s; ++y) {
                    c = src[kohta];
                    r += c >> 16 & 0xFF;
                    g += c >> 8 & 0xFF;
                    b += c & 0xFF;
                    kohta += w;
                }
                kohta = x;
                for (y = 0; y < s; ++y) {
                    c = src[kohta + s2];
                    dest[kohta] = (r += c >> 16 & 0xFF) * osa & 0xFF0000 | (g += c >> 8 & 0xFF) * osa >> 8 & 0xFF00 | (b += c & 0xFF) * osa >> 16;
                    kohta += w;
                }
                for (y = s; y < h - s; ++y) {
                    c = src[kohta + s2];
                    c2 = src[kohta - s2];
                    r += c >> 16 & 0xFF;
                    g += c >> 8 & 0xFF;
                    b += c & 0xFF;
                    dest[kohta] = (r -= c2 >> 16 & 0xFF) * osa & 0xFF0000 | (g -= c2 >> 8 & 0xFF) * osa >> 8 & 0xFF00 | (b -= c2 & 0xFF) * osa >> 16;
                    kohta += w;
                }
                for (y = h - s; y < h; ++y) {
                    c2 = src[kohta - s2];
                    dest[kohta] = (r -= c2 >> 16 & 0xFF) * osa & 0xFF0000 | (g -= c2 >> 8 & 0xFF) * osa >> 8 & 0xFF00 | (b -= c2 & 0xFF) * osa >> 16;
                    kohta += w;
                }
            }
        }
    }

    public void initNoise() {
        int col = 0;
        this.noisemap = new int[65536];
        for (int i = 0; i < 65536; ++i) {
            this.noisemap[i] = col = col + (int)(Math.random() * 256.0) >> 1;
        }
    }

    public void noise(int amount2) {
        int amount = amount2 + (int)(Math.random() * 4.0 - 2.0);
        if (amount > 255) {
            amount = 255;
        }
        int p = amount;
        int p2 = 255 - amount;
        int r = (int)(Math.random() * 65535.0) + amount * 232151 & 0xFFFF;
        if (amount > 0 && amount < 256) {
            for (int i = 0; i < this.src.length; ++i) {
                int c1 = this.src[i];
                int c2 = p * this.noisemap[i + r & 0xFFFF] >> 8;
                this.src[i] = (p2 * (c1 & 0xFF00FF) >> 8 & 0xFF00FF) + (c2 << 16 | c2) | ((c1 & 0xFF00) * p2 >> 8 & 0xFF00) + (c2 << 8);
            }
        }
    }

    public void blendAdd(int[] src1, int[] src2, int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int c1 = src1[i];
            int c2 = src2[i];
            int r = (c1 >> 16 & 0xFF) + (c2 >> 16 & 0xFF);
            int g = (c1 >> 8 & 0xFF) + (c2 >> 8 & 0xFF);
            int b = (c1 & 0xFF) + (c2 & 0xFF);
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            dest[i] = r << 16 | g << 8 | b;
        }
    }
}

