#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <GL/gl.h>
#include <SDL.h>
#include <vorbis/vorbisfile.h>
#ifdef USE_DL
	#include <unistd.h>
	#include <dlfcn.h>
	#include <sys/types.h>
	#include <sys/stat.h>
	struct stat statti;
	#define stat_mtime(file) (stat(file, &statti), statti.st_mtime)
	#define stat_size(file) (stat(file, &statti), statti.st_size)
#endif

#include "demosys.h"

#ifdef USE_PA
	// sdl_audio is fucked up for some reason - complains about DPMIDisable
	#include <portaudio.h>
#endif

static int done;


#define die(...) (fprintf(stderr, __VA_ARGS__), exit(EXIT_FAILURE))

#define MAX_TICKS_PER_FRAME 16

static volatile int volatilewavpos = 0, wavsize, wavspeed = 256;
static short *wavdata;
#ifdef USE_PA
static int audiocallback(void *input, void *output, unsigned long frames, PaTimestamp t, void *user) {
#else
static void audiocallback(void *user, Uint8 *output, int len) {
	unsigned long frames = len>>2;
#endif
	int pos = volatilewavpos;
	int z = wavsize-frames;
	pos = (pos%z+z)%z;
	if (wavspeed==0) for (int i = 0; i<frames*2; i++) ((short*)output)[i] = 0; else for (int i = 0; i<frames; i++) {
		((short*)output)[i*2  ] = wavdata[pos*2+i*2  ];
		((short*)output)[i*2+1] = wavdata[pos*2+i*2+1];
	}
	pos += (int)frames*wavspeed>>8;
	if (pos>z) done = 1;
	volatilewavpos = (pos%z+z)%z;
	#ifdef USE_PA
	return 0;
	#endif
}


struct resource {
	void *p;
	int id;
};
struct resource resources[256];

void *findres(int resid) {
	struct resource *res = resources+(resid&0xff);
	return res->id==resid ? res->p : 0;
}
void addres(int resid, void *data) {
	struct resource *res = resources+(resid&0xff);
	res->id = resid;
	res->p = data;
	printf("res %i created\n", res->id);
}
void freeres(int resid) {
}




int main(int argc, char *argv[]) {
	SDL_Surface *screen;
	int fullscreen = 1;
	Uint8 *keys;
	int err;
	int looppos = -1;

	int prefw = 1024, prefh = 768;
	for (int i = 1; i<argc; i++) {
		if (strncmp(argv[i], "-win", 4)==0) {
			fullscreen = 0;
		} else if (strncmp(argv[i], "-full", 5)==0) {
			fullscreen = 1;
		} else if (strncmp(argv[i], "-w", 2)==0 && i+1<argc) {
			prefw = atoi(argv[++i]);
		} else if (strncmp(argv[i], "-h", 2)==0 && i+1<argc) {
			prefh = atoi(argv[++i]);
		} else { die("options are -win, -full, -w <width>, -h <height>\n"); }
	}

	{
		FILE *fp = fopen("sedarka_galas_2.ogg", "rb");
		OggVorbis_File ovf;
		if (ov_open(fp, &ovf, 0, 0)!=0) die("ogg open failed");

		int az = 1024;
		wavdata = malloc(az);
		{
			int pos = 0;
			for (;;) {
				if (pos+1024>az) wavdata = realloc(wavdata, az*=2);
				int cnt = ov_read(&ovf, (char*)wavdata+pos, 1024, 0, 2, 1, 0);
				if (cnt<=0) break;
				pos += cnt;
			}
			wavdata = realloc(wavdata, pos);
			wavsize = pos>>2;
		}
		ov_clear(&ovf);
	}

	#ifdef USE_PA
		SDL_Init(SDL_INIT_VIDEO);
		PortAudioStream *audiostream;
		if ((err = Pa_Initialize())!=paNoError || (err = Pa_OpenDefaultStream(
			&audiostream,
			0,
			2,
			paInt16,
			44100,
			512,
			0,
			audiocallback,
			0
		))!=paNoError) die("audio failed: %s", Pa_GetErrorText(err));
	#else
		SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO);
		SDL_AudioSpec sdldev;
		sdldev.freq = 44100;
		sdldev.format = AUDIO_S16;
		sdldev.channels = 2;
		sdldev.samples = 512;
		sdldev.callback = audiocallback;
		sdldev.userdata = 0;
		if (SDL_OpenAudio(&sdldev, 0)<0) die("audio failed: %s", SDL_GetError());
	#endif


	screen = fullscreen ?
		SDL_SetVideoMode(prefw, prefh, 16, SDL_OPENGL|SDL_RESIZABLE|SDL_HWSURFACE|SDL_FULLSCREEN):
		SDL_SetVideoMode(prefw ? prefw : 800, prefh ? prefh : 500, 16, SDL_OPENGL|SDL_RESIZABLE|SDL_HWSURFACE);

	//atexit(SDL_Quit);
	if (!screen) die("Couldn't set video mode: %s\n", SDL_GetError());
	if (fullscreen) SDL_ShowCursor(0);
	glFinish();
/*	if (argc > 1 && strcmp(argv[1], "-info") == 0) {
		printf("GL_RENDERER   = %s\n", (char *)glGetString(GL_RENDERER));
		printf("GL_VERSION    = %s\n", (char *)glGetString(GL_VERSION));
		printf("GL_VENDOR     = %s\n", (char *)glGetString(GL_VENDOR));
		printf("GL_EXTENSIONS = %s\n", (char *)glGetString(GL_EXTENSIONS));
	}*/

	done = 0;

	int wavpos = 0;


	#ifdef USE_DL
		char *sofilename = "./stuff.so";
		void *dlhandle = dlopen(sofilename, RTLD_LAZY|RTLD_GLOBAL);
		drawframefunc *drawframe = (drawframefunc*)(dlhandle ? (long)dlsym(dlhandle, "drawframe") : 0);
		time_t oldtime = stat_mtime(sofilename);
	#endif

	#ifdef USE_PA
		Pa_StartStream(audiostream);
	#else
		SDL_PauseAudio(0);
	#endif
	int faketicker = SDL_GetTicks();
	int debugmode = 0;

	while (!done) {
		SDL_Event event;

		while (SDL_PollEvent(&event)) {
			switch (event.type) {
				case SDL_VIDEORESIZE:
					screen = SDL_SetVideoMode(event.resize.w, event.resize.h, 16, SDL_OPENGL | SDL_RESIZABLE | SDL_HWSURFACE | (fullscreen ? SDL_FULLSCREEN : 0));
					memset(resources, 0, sizeof resources);
					if (!screen) die("couldn't set video mode");
					break;

				case SDL_QUIT:
					done = 1;
					break;
				case SDL_KEYDOWN:
					if (event.key.keysym.sym==SDLK_ESCAPE) done = 1;
					int spd = wavspeed;
					if (event.key.keysym.sym==SDLK_LEFT) spd = -1024;
					else if (event.key.keysym.sym==SDLK_HOME) { spd = 256; volatilewavpos = 0; }
					else if (event.key.keysym.sym==SDLK_RIGHT) spd = 1024;
					else if (event.key.keysym.sym==SDLK_SPACE) spd = spd==0 ? 256 : 0;
					else if (event.key.keysym.sym=='d') debugmode = !debugmode;
					else if (event.key.keysym.sym=='l') looppos = looppos==-1 ? volatilewavpos : -1;
					else if (event.key.keysym.sym=='r') memset(resources, 0, sizeof resources);
					else if (event.key.keysym.sym=='f') {
						fullscreen = !fullscreen;
						screen = fullscreen ?
							SDL_SetVideoMode(prefw, prefh, 16, SDL_OPENGL|SDL_RESIZABLE|SDL_HWSURFACE|SDL_FULLSCREEN):
							SDL_SetVideoMode(prefw ? prefw : 960, prefh ? prefh : 540, 16, SDL_OPENGL|SDL_RESIZABLE|SDL_HWSURFACE);
						if (!screen) die("couldn't set video mode");
					}
					wavspeed = spd;
					break;
			}
		}
		if (looppos!=-1 && volatilewavpos>looppos+88200) volatilewavpos = looppos;
		keys = SDL_GetKeyState(NULL);

		#ifdef USE_DL
			time_t newtime = stat_mtime(sofilename);
			if (newtime!=oldtime) {
				if (dlhandle) dlclose(dlhandle);
				dlhandle = dlopen(sofilename, RTLD_LAZY);
				drawframe = (drawframefunc*)(dlhandle ? (long)dlsym(dlhandle, "drawframe") : 0);
				oldtime = newtime;
			}
		#endif

		static float lbuf[512], rbuf[512];

		int pos = volatilewavpos*2;
		for (int i = 0; i<512; i++) {
			lbuf[i] = wavdata[pos+i*2]*(1./32768);
		}

		glViewport(0, 0, screen->w, screen->h);
		glMatrixMode(GL_TEXTURE);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glPushAttrib(GL_ALL_ATTRIB_BITS);
		if (drawframe) {
			struct demoinfo inf;
			inf.demotime = volatilewavpos*(1./44100)/**(125./60)*/;
			inf.w = screen->w;
			inf.h = screen->h;
			inf.aspect = inf.w*1.0/inf.h;
			inf.left = lbuf;
			inf.get = findres;
			inf.set = addres;
			inf.free = freeres;

			drawframe(&inf);
			if (debugmode) printf("%f\n", inf.demotime);
		}
		glPopAttrib();
		SDL_GL_SwapBuffers();
		glFinish();

		faketicker += MAX_TICKS_PER_FRAME;
		int tck = SDL_GetTicks();
		if (faketicker<tck-50) faketicker = tck-50;
		if (faketicker>tck+50) faketicker = tck+50;
		if (faketicker>tck+5) { int i = faketicker-tck; SDL_Delay(i); /*printf("delaying: %i\n", i);*/ } else { /*puts("not delaying");*/ }
		if (wavspeed==0) SDL_Delay(100);
	}
	SDL_Quit();
	return 0;
}

