#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include "demosys.h"
#include <math.h>

static float sigmoid(float x) { return x/(1+fabs(x)); }

struct tex {
	float xmin, xmax, ymin, ymax;
	GLuint id;
};
static struct demoinfo inf;

static void thiran1(float *buf, int n, int stride, float shift) {
	if (shift>0) buf += (n-1)*stride, stride = -stride, shift = -shift;
	float D = shift+1;
	float a1 = (1-D)/(1+D);
	for (int i = 2; i<n-2; i++) buf[i*stride] += (buf[(i+1)*stride]-buf[(i-1)*stride])*a1;
}
static void thiran2(float *buf, int n, int stride, float shift) {
	if (shift>0) buf += (n-1)*stride, stride = -stride, shift = -shift;
	float D = shift+2;
	float a1 = 2*(2-D)/(1+D), a2 = ((1-D)*(2-D))/((1+D)*(2+D));
	int i = 1;
	buf[i*stride] += (buf[(i+1)*stride]-buf[(i-1)*stride])*a1;
	for (i = 2; i<n-2; i++) buf[i*stride] += (buf[(i+1)*stride]-buf[(i-1)*stride])*a1+(buf[(i+2)*stride]-buf[(i-2)*stride])*a2;
	buf[i*stride] += (buf[(i+1)*stride]-buf[(i-1)*stride])*a1;
}

static int viewx0, viewy0, viewwidth, viewheight;
static void setupframe(float preferredaspect) {
	glViewport(0,0,256,256);
	glMatrixMode(GL_PROJECTION);
	if (inf.aspect>preferredaspect) {
		viewwidth = inf.w*preferredaspect/inf.aspect;
		viewheight = inf.h;
	} else {
		viewwidth = inf.w;
		viewheight = inf.h*inf.aspect/preferredaspect;
	}
	glViewport(viewx0=(inf.w-viewwidth)*.5, viewy0=(inf.h-viewheight)*.5, viewwidth, viewheight);
	glMatrixMode(GL_MODELVIEW);
}

static void bindtex(struct tex *tex) {
	glBindTexture(GL_TEXTURE_2D, tex->id);
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();
	glTranslatef(tex->xmin, tex->ymin, 0);
	glScalef((tex->xmax-tex->xmin), (tex->ymax-tex->ymin), 1);
	glMatrixMode(GL_MODELVIEW);
}

static struct tex *gettexture(char *fname) {
	int resid = 0;
	for (char *p=fname; *p; p++) resid = resid*31+*p;
	resid ^= resid>>19;

	struct tex *tex = inf.get(resid);
	if (tex) return tex;
	FILE *fp = fopen(fname, "rb");
	int w, h;
	{
		static char tmp[100];
		do { fgets(tmp, sizeof tmp, fp); } while (tmp[0]=='#'); //p = atoi(tmp+1);
		do { fgets(tmp, sizeof tmp, fp); } while (tmp[0]=='#'); sscanf(tmp, "%d %d", &w, &h);
		do { fgets(tmp, sizeof tmp, fp); } while (tmp[0]=='#'); //sscanf(tmp, "%d", c);
	}
	char *buf = malloc(w*h);
	fread(buf, w*h, 1, fp);
	fclose(fp);
	glPushAttrib(GL_TEXTURE_BIT);

	tex = malloc(sizeof *tex);
	glGenTextures(1, &tex->id);
	glBindTexture(GL_TEXTURE_2D, tex->id);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	tex->xmin = 0; tex->ymin = 0; tex->xmax = 1; tex->ymax = 1;
	glTexImage2D(GL_TEXTURE_2D, 0, GL_LUMINANCE, w, h, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, buf);
	free(buf);
	inf.set(resid, tex);
	glPopAttrib();
	return tex;
}

static int nextpow2(int a) {
	a--; a |= a>>1; a |= a>>2; a |= a>>4; a |= a>>8; a |= a>>16; return a+1;
}


static struct tex *getscreen(int scrn) {
	struct tex *tex = inf.get(0x100+scrn);
	glPushAttrib(GL_TEXTURE_BIT);
	if (tex) glBindTexture(GL_TEXTURE_2D, tex->id); else {
		tex = malloc(sizeof *tex);
		glGenTextures(1, &tex->id);
		glBindTexture(GL_TEXTURE_2D, tex->id);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		tex->xmin = 0;
		tex->xmax = viewwidth*1./nextpow2(viewwidth);
		tex->ymin = viewheight*1./nextpow2(viewheight);
		tex->ymax = 0;
		glTexImage2D(GL_TEXTURE_2D, 0, GL_LUMINANCE, nextpow2(viewwidth), nextpow2(viewheight), 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);
		inf.set(0x100+scrn, tex);
	}
	glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, viewx0, viewy0, viewwidth, viewheight);
	glPopAttrib();
	return tex;

}
/*
static int getscreen(int scrn) {
	glPushAttrib(GL_TEXTURE_BIT);
	int *id = inf.get(0x100+scrn);
	if (id) glBindTexture(GL_TEXTURE_2D, *id); else {
		GLuint texid;
		glGenTextures(1, &texid);
		id = malloc(sizeof *id); *id = texid;
		glBindTexture(GL_TEXTURE_2D, *id);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		static char shittii[1024*1024];
		glTexImage2D(GL_TEXTURE_2D, 0, GL_LUMINANCE, 256, 256, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, shittii);
		//glTexImage2D(GL_TEXTURE_2D, 0, GL_LUMINANCE, nextpow2(inf.w), nextpow2(inf.h), 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, shittii);
		inf.set(0x100+scrn, id);
	}
//
	glPopAttrib();
}*/

static void showtex(struct tex *tex, float xsz, float ysz, float k) {
	glBindTexture(GL_TEXTURE_2D, tex->id);
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glEnable(GL_TEXTURE_2D);
	glColor3f(k, k, k);
	glBegin(GL_QUAD_STRIP);
	glTexCoord2f(tex->xmin, tex->ymin); glVertex2f(-xsz,  ysz);
	glTexCoord2f(tex->xmin, tex->ymax); glVertex2f(-xsz, -ysz);
	glTexCoord2f(tex->xmax, tex->ymin); glVertex2f( xsz,  ysz);
	glTexCoord2f(tex->xmax, tex->ymax); glVertex2f( xsz, -ysz);
	glEnd();
	glDisable(GL_TEXTURE_2D);
}

static void distorttex(struct tex *tex, float rot, int n, float *sig, float k) {
 	bindtex(tex);
	glMatrixMode(GL_TEXTURE);
	glTranslatef(.5, .5, 0);
	glRotatef(-rot, 0, 0, 1);
	glScalef(1.5, 1.5, 1.5);
	glTranslatef(-.5, -.5, 0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glRotatef(rot, 0, 0, 1);
	glScalef(1.5, 1.5, 1.5);

	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glEnable(GL_TEXTURE_2D);
	glColor3f(1, 1, 1);
	glBegin(GL_QUAD_STRIP);
	float invn = 1./n;
	for (int i = 0; i<n; i++) {
		glTexCoord2f(i*invn, 0+((i&1)-.5)*k); glVertex2f(i*invn*2-1,  1);
		glTexCoord2f(i*invn, 1+((i&1)-.5)*k); glVertex2f(i*invn*2-1, -1);
	}
	glEnd();
	glDisable(GL_TEXTURE_2D);
}





static float pows[9];
static void calcpows(void) {
	static float tmp[512];
	for (int i = 0; i<512; i++) tmp[i] = inf.left[i];
	for (int j = 0, sz=512; j<9; j++, sz>>=1) {
		pows[j] = (tmp[0]-tmp[1])*(tmp[0]-tmp[1])+(tmp[sz-1]-tmp[sz-2])*(tmp[sz-1]-tmp[sz-2]);
		for (int i = 1; i<sz-1; i++) {
			float a = tmp[i]-(tmp[i+1]+tmp[i-1])*.5;
			pows[j] += a*a;
		}
		pows[j] *= 1./sz;
		for (int i = sz>>1; i>=0; i--) tmp[i] = (tmp[i*2]+tmp[i*2+1])*.5;
	}
}

static void stroob(float v) {
 	float powa = 0;
	powa = pow(pows[4], .2);
	glColor3f(v, v, v);
	glBegin(GL_QUAD_STRIP);
	glVertex2f(-1, -1);
	glVertex2f(-1,  1);
	glVertex2f( 1, -1);
	glVertex2f( 1,  1);
	glEnd();
}

static void showsignal(void) {
	int start = 0;
	if (1) {
		static float tmp[512];
		tmp[0] = 0;
		for (int i = 0; i<64; i++) tmp[0] += inf.left[i];
		for (int i = 1; i<512-64; i++) tmp[i] = tmp[i-1]+(inf.left[i]-inf.left[i+64]);
		for (int i = 1; i<256; i++) if (tmp[i]-tmp[i+64]<tmp[start]-tmp[start+64]) start = i;
	} else {
		float frq = exp(sin(inf.demotime*.3)*2)*.3;
		for (int i = 0; i<256; i++) inf.left[i] = sin((i-128)*frq)*.5;
	}

	for (int i = 0; i<8; i++) thiran2(inf.left+i, 64, 8, (i-3.5)/8);
	for (int i = 0; i<8; i++) thiran2(inf.left+i, 64, 8, (i-3.5)/8);
	for (int i = 0; i<8; i++) thiran2(inf.left+i, 64, 8, (i-3.5)/8);
/*	for (int i = 0; i<512; i += 8) { float a = 0; for (int j = 0; j<8; j++) a+=inf.left[i+j]*(1./8); for (int j = 0; j<8; j++) inf.left[i+j] = a; }
	for (int i = 0; i<8; i++) thiran2(inf.left+i, 64, 8, (3.5-i)/8);*/

	glColor3f(1, 1, 1);
	glBegin(GL_QUAD_STRIP);
	for (int i = 0; i<256; i++) {
		float x = (i-128)*(1./128), y = sigmoid(inf.left[start+i]*5)*.2;
		glVertex2f(x, y-x*.3);
		glVertex2f(x, y+x*.3);
	}
	glEnd();

}

static float stp(float f, float x0, float x1) {
	return f<x0 ? 0 : f>x1 ? 1 : (f-x0)/(x1-x0);
}
static float clamp(float f) {
	return f<0 ? 0 : f>1 ? 1 : f;
}

static void desig(void) {
	if (inf.demotime<20) {
		float k = stp(inf.demotime, 0, .2)*.5+stp(inf.demotime, .8, 1)*.5-stp(inf.demotime, 19, 20);
		showtex(gettexture("mfx.pgm"), .125, .2, pow(clamp(k), .4));
	} else if (inf.demotime<34.8) {
		showsignal();
	} else if (inf.demotime<49) {
		showsignal();
		distorttex(getscreen(42), pows[1 ]*1000, 16, 0, pows[7]);
	} else if (inf.demotime<90) {
		showsignal();
		distorttex(getscreen(42), pows[4]*1000, 64, 0, pows[1]*.3);
		distorttex(getscreen(42), pows[4]*1000+30, 64, 0, pows[2]*.3);
		distorttex(getscreen(42), pows[4]*1000+60, 64, 0, pows[3]*.3);
	} else  {
		showsignal();
		distorttex(getscreen(42), inf.demotime*10, 256, 0, pows[7]*.3);
/*		distorttex(getscreen(42), pows[4]*1000, 64, 0, pows[1]*.3);
		distorttex(getscreen(42), pows[4]*1000+30, 64, 0, pows[2]*.3);
		distorttex(getscreen(42), pows[4]*1000+60, 64, 0, pows[3]*.3);
		distorttex(getscreen(42), 0, 4, 0, pows[7]*.3);*/
	}
}

void drawframe(struct demoinfo *dinf) {
	inf = *dinf;
	glClear(GL_COLOR_BUFFER_BIT);
	calcpows();
	setupframe(1.6);
	desig();
//	stroob();
//	showsignal();
//	distorttex(getscreen(42), pows[4]*1000, .3, 64, 0);
//	distorttex(getscreen(42), dinf->demotime*100, .3, 64, 0);
//	showtex(gettexture("mfx.pgm"));
	return;

}

