float4x4	wMatrix 	: World;
float4x4	vpMatrix	: ViewProjection;
float4x4 	wvpMatrix 	: WorldViewProjection;
float4x4	rotMatrix = float4x4( 	1.0f, 0.0f, 0.0f, 0.0f,
									0.0f, 1.0f, 0.0f, 0.0f,
									0.0f, 0.0f, 1.0f, 0.0f,
									0.0f, 0.0f, 0.0f, 0.0f );
float3		upperColor
<
	string UIName = "Upper Color";
> = { 0.0f, 0.0f, 0.0f };

float3		bottomColor
<
	string UIName = "Lower Color";
> = { 0.0f, 0.0f, 0.0f };

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

texture texture_0;
sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = mirror;        
    AddressV  = mirror;
    AddressW  = mirror;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexOutput {
    float4 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
    float2 exponent : TEXCOORD1;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    float4x4 comboMatrix = mul( rotMatrix, wMatrix );

	OUT.position = mul(float4(IN.Position,1.0f), wMatrix);
    OUT.position = normalize( OUT.position );
    OUT.position = mul( OUT.position, vpMatrix );

  
    OUT.position = mul(float4(IN.Position,1.0f), wvpMatrix);
    OUT.position = normalize( OUT.position );
	OUT.exponent = exp(IN.Position.y/200.0f)/2.72;
	OUT.uvCoords = IN.uvCoords;
	
    return OUT;
}

VertexOutput VS_Reflect(VertexInput IN) {
    VertexOutput OUT;
    
    float4x4 comboMatrix = mul( rotMatrix, wMatrix );
  
  	IN.Position.y = -IN.Position.y+100.0f;
    OUT.position = mul(float4(IN.Position,1.0f), wMatrix);
    OUT.position = normalize( OUT.position );
    OUT.position = mul( OUT.position, vpMatrix );
	OUT.exponent = exp(IN.Position.y/200.0f)/2.72;
	OUT.uvCoords = IN.uvCoords;
	
    return OUT;
}

float4 PS_Sky( VertexOutput IN ) : COLOR
{
	return float4(upperColor*IN.exponent.x + bottomColor*(1.0f-IN.exponent.x)+tex2D(texture_0Sampler,IN.uvCoords),1.0f);
}
float4 PS_SkyReflect( VertexOutput IN ) : COLOR
{
	clip( -IN.exponent.y+0.5f );
	return float4(upperColor*IN.exponent.x + bottomColor*(1.0f-IN.exponent.x)+tex2D(texture_0Sampler,IN.uvCoords),1.0f);
}

technique Reflect
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Reflect();
		PixelShader = compile ps_2_0 PS_SkyReflect();
		
		CullMode = cw;
		ZEnable = false;
    }
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Ambient();
		PixelShader = compile ps_2_0 PS_Sky();
		
		ZEnable = false;
    }
}


