float4x4 matView;
float4x4 matViewProjection;

float2 ParticleSize = {5.f, 5.f};

texture tex0; //diffuse
sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

void vs_partikkel(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0)
{
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
}

float4 ps_partikkel(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(diffuse, tex);
}

technique Partikkel
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_partikkel();
	}
}