float4x4 matWorldViewProjection;
float4x4 matLightViewProjection;
float4x4 matView;
float alpha1 = 1.f;
float time; 
float3 LightPosition = {0.f, 100.f, 0.f};
texture tex0;
texture tex1;
texture tex2;

sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D b = 
sampler_state 
{
	texture = (tex1);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};
sampler2D c	 = 
sampler_state 
{
	texture = (tex2);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};


void vs_main(in float4 ipos : POSITION, 
			    in float2 itex : TEXCOORD0,
			    in float3 inormal : NORMAL,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 lightdir : TEXCOORD2,
			    out float4 lightpos : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	onormal = mul(inormal, matView);
	lightdir = normalize(LightPosition - mul(ipos, matView));
	lightpos = mul(ipos, matLightViewProjection);
}

float4 ps_single(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2,
				 in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	
	float diffuse = dot(normal, lightdir);
	float4 spotlight = tex2D(b, spot);
	//return spotlight*diffuse;
	return tex2D(a, itex)*alpha1*diffuse*spotlight;
}

float4 ps_single2(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2,
				 in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	
	float diffuse = dot(normal, lightdir);
	float4 spotlight = tex2D(b, spot);
	float4 shadow = tex2D(c, spot);
//	return spotlight*diffuse;
	return tex2D(a, itex)*alpha1*diffuse*spotlight*shadow;
}


technique Div
{
	pass Singel
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single();
	}
	
	pass SingelShadow
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single2();
	}
}