float4x4 matView;
float4x4 matViewProjection;


float FogStart = 0.f;         //partikkel fog pass3
float FogEnd = 100.f;         //partikkel fog pass3
float3 CameraPosition = {0.f, 100.f, 0.f}; //partikkel fog

float time = 0.f;
float2 ParticleSize = {5.f, 5.f};

texture tex0; //diffuse
sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

void vs_partikkel(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2)
{
	float factor = ipos.y;//length(ipos.xyz);
	float dude = ((factor/40.f)*8.f);
	inter = frac(dude);
	int part = floor(dude);
	float xcoord = 1.f/8.f; 
	
	ipos.y = 60.f*sin( (ipos.y/40)*1.2f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
	otex2 = otex;
	
	float x = otex.x;
	otex.x = otex.x  * xcoord + (xcoord*part);
	otex2.x = x  * xcoord + (xcoord*(part+1));
}

void vs_partikkel2(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2)
{
	//float factor = ipos.y;//length(ipos.xyz);
	float dude = 4.f+4.f*sin(length(ipos)+time);//((factor/40.f)*8.f);
	inter = frac(dude);
	int part = floor(dude);
	float xcoord = 1.f/8.f; 
	
	ipos.y = 60.f*sin( (ipos.y/40)*1.8f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
	otex2 = otex;
	
	float x = otex.x;
	otex.x = otex.x  * xcoord + (xcoord*part);
	otex2.x = x  * xcoord + (xcoord*(part+1));
}

void vs_partikkel3(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2,
				  out float  fog : TEXCOORD3)
{
	float dude = 4.f+4.f*sin(length(ipos)+time);//((factor/40.f)*8.f);
	inter = frac(dude);
	int part = floor(dude);
	float xcoord = 1.f/8.f; 
	
	ipos.y = 60.f*sin( (ipos.y/40)*1.2f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
	otex2 = otex;
	
	float x = otex.x;
	otex.x = otex.x  * xcoord + (xcoord*part);
	otex2.x = x  * xcoord + (xcoord*(part+1));
	
//	fog = 1.f;
	FogEnd = 400.f;
	FogStart = 100.f;
	fog =  1.f-clamp( (length(CameraPosition-ipos.xyz)-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	//fog = pow(fog, 5.f);
	
}




void vs_psimple(in float3 ipos : POSITION,
				in float2 itex : TEXCOORD0,
				out float4 opos : POSITION,
				out float2 otex : TEXCOORD0)
{
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	
	otex =  itex  + .5f;
	otex.y = 1.f-otex.y;
}

float4 ps_partikkel(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	return lerp(a, b, inter);
}

float4 ps_partikkelfog(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2,
					in float fog : TEXCOORD3) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	return lerp(a, b, inter)*fog;
}



float4 ps_psimple(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(diffuse, tex);
}

technique Partikkel
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_partikkel();
	}
	
	pass diff2
	{
		VertexShader = compile vs_2_0 vs_partikkel2();
		PixelShader  = compile ps_2_0 ps_partikkel();
	}
	
	pass Simple
	{
		VertexShader = compile vs_2_0 vs_psimple();
		PixelShader  = compile ps_2_0 ps_psimple();
	}
	
	pass diff3
	{
		VertexShader = compile vs_2_0 vs_partikkel3();
		PixelShader  = compile ps_2_0 ps_partikkelfog();
	}
}