float4x4 matWorldViewProjection; 
float4x4 matLightViewProjection;
float4x4 matView;

float3 LightPosition = {0.f, 100.f, 100.f};
float gamma = 1.f;

texture tex0;
texture tex1;
texture tex2;

sampler2D normalmap = 
sampler_state
{
	texture = (tex0);
	AddressV = Wrap; AddressU = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

sampler2D diffusemap = 
sampler_state
{
	texture = (tex1);
	AddressV = Wrap; AddressU = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

sampler2D lightmap = 
sampler_state
{
	texture = (tex2);
	AddressV = Clamp; AddressU = Clamp;
	MipFilter = None; MagFilter = Linear; MinFilter = Linear;
};

void vs_main(in float4 ipos : POSITION,
			 in float3 inorm : NORMAL,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0,
			 out float3 onorm : TEXCOORD1,
			 out float3 lightv : TEXCOORD2,
			 out float4 lightpos : TEXCOORD3)
{	
	opos = mul(ipos, matWorldViewProjection);
	onorm = mul(inorm, matView);
	otex = itex;
	lightv = normalize(LightPosition - mul(ipos, matView));
	lightpos = mul(ipos, matLightViewProjection);
}

float4 ps_main(in float2 tex : TEXCOORD0,
			   in float3 normal : TEXCOORD1,
			   in float3 lightv : TEXCOORD2,
			   in float4 lightpos : TEXCOORD3) : COLOR0
{

	float2 light = .5f * lightpos.xy / lightpos.w + float2(.5f, .5f);
	light.y = 1.f - light.y;
	float4 thislight = tex2D(lightmap, light);
//	return tex2D(lightmap, light);
	
	//return  tex2Dproj(lightmap, lightpos);
	
	float3 kuk = tex2D(normalmap, tex);
	kuk.z = 1.f-kuk.z;
	float4 sdif = dot(kuk*normal, lightv);
	float4 base = tex2D(diffusemap, tex);
	return sdif*base*thislight*gamma;
	
//	return float4(normal, 1.f);
	//return float4(1.f, 0.f, 0.f, 1.f);
//	float3 kuk = tex2D(normalmap, tex);
	
	return float4(kuk, 1.f);//
	//return float4(lightv, 1.f);
	float diffuse = dot(kuk, lightv);
	return diffuse; 
}

technique Ground
{
	pass p1
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_main();
	}
}