float4x4 matWorldViewProjection;
float4x4 matLightViewProjection;
float4x4 matView;
float alpha1 = 1.f;
float time; 
float3 LightPosition = {0.f, 100.f, 0.f};
texture tex0; //diffuse
texture tex1; //spotlight
texture tex2; //shadow
texture tex3; //normal

sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D b = 
sampler_state 
{
	texture = (tex1);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};
sampler2D c	 = 
sampler_state 
{
	texture = (tex2);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};

sampler2D d	 = 
sampler_state 
{
	texture = (tex3);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};

void vs_main(in float4 ipos : POSITION, 
			    in float2 itex : TEXCOORD0,
			    in float3 inormal : NORMAL,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 lightdir : TEXCOORD2,
			    out float4 lightpos : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex.y += 1.f;
	onormal = mul(inormal, matView);
	lightdir = normalize(LightPosition - mul(ipos, matView));
	lightpos = mul(ipos, matLightViewProjection);
}

float4 ps_diffuse_spot(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2,
				 in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	
	float diffuse = dot(normal, lightdir);
	float4 spotlight = tex2D(b, spot);
	return tex2D(a, itex)*alpha1*diffuse*spotlight;
}

float4 ps_diffuse_spot_shadow(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2,
				 in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	
	float diffuse = dot(normal, lightdir);
	float4 spotlight = tex2D(b, spot);
	float4 shadow = tex2D(c, spot);
	return tex2D(a, itex)*alpha1*diffuse*spotlight*shadow;
}

float4 ps_diffuse_spot_shadow_normal(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2,
				 in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	
	float4 spotlight = tex2D(b, spot);
	float4 shadow = tex2D(c, spot);

	float3 thisnormal =  normalize(tex2D(d, itex));//*normal);
	float baseDiffuse = dot(thisnormal*normal, lightdir);
	float4 baseColor = tex2D(a, itex);
	
	return (baseDiffuse*baseColor)*(spotlight*shadow)*alpha1;
//	return tex2D(a, itex)*alpha1*diffuse*spotlight*shadow;
}

float4 ps_diffuse_spot_normal(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2,
				 in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	float4 spotlight = tex2D(b, spot);
	float3 thisnormal =  normalize(tex2D(d, itex)*normal);
	float baseDiffuse = dot(thisnormal, lightdir);
	float4 baseColor = tex2D(a, itex);
	
	return (baseDiffuse*baseColor)*spotlight*alpha1;
}

technique Div
{
	pass DiffuseSpot
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffuse_spot();
	}
	
	pass DiffuseSpotShadow
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffuse_spot_shadow();
	}
	
	pass DiffuseSpotShadowNormal
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffuse_spot_shadow_normal();
	}
	
	pass DiffuseSpotNormal
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffuse_spot_normal();
	}
}