float4x4 matWorldViewProjection;
float4x4 matWorld; 
texture tex0;

float FogStart = 0.f;
float FogEnd   = 200.f;
float3 CameraPosition = {0.f, 100.f, 0.f};
sampler2D DiffuseMap = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressV = Clamp; AddressU = Clamp;
};

void vs_main(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float  fog : TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
	fog = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}

float4 ps_fog(in float2 tex : TEXCOORD0,
			  in float fog : TEXCOORD1) : COLOR0
{
	return tex2D(DiffuseMap, tex)*fog;
}

technique Texture
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_fog(); 
	}
}