float4x4 matWorldViewProjection; 
float4x4 matLightViewProjection;
float4x4 matView; 
float3  LightPosition = {0.f, 100.f, 0.f};

texture tex0;  //spotlight
texture tex1;  //diffuse
texture tex2;  //shadowmap
texture tex3;  //skitt

float alpha1 = 1.f; //pass1 aktuell
float time = 0.f;

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = None; MagFilter = Point; MinFilter = Point;	
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D b = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear;	MagFilter = Linear;	MinFilter = Linear; 
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D c = 
sampler_state
{
	texture = (tex2);
	MipFilter = None; MagFilter = Linear;	MinFilter = Linear; 
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D d = 
sampler_state
{
	texture = (tex3);
	MipFilter = Linear; MagFilter = Linear;	MinFilter = Linear; 
	AddressU = Wrap; AddressV = Wrap;
};

void vs_kubegrid(in float4 ipos : POSITION,
			     in float2 itex : TEXCOORD0,
			     in float3 inormal : NORMAL,
			     in float3 binormal : BINORMAL,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 lightdir : TEXCOORD2,
			    out float4 lightpos : TEXCOORD3,
			    out float2 tt : TEXCOORD4)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y = 1.f - otex.y;
	onormal = mul(inormal, matView);
	lightdir = normalize(LightPosition - mul(ipos, matView));
	lightpos = mul(ipos, matLightViewProjection);


	tt = (binormal.xz+ float2(200.f, 200.f))/400.f;
	tt.x = ((binormal.x+200.f)/400.f);
	tt.y = ((binormal.z+200.f)/400.f);
	tt.x -= (itex.x-.5f)/40.f;
	tt.y += (itex.y-.5f)/40.f;
	tt.y+=time;
}



float4 ps_kubegrid3(in float2 tex : TEXCOORD0,
				   in float3 normal : TEXCOORD1,
				   in float3 lightdir : TEXCOORD2,
				   in float4 lightpos : TEXCOORD3,
				   in float2 tt : TEXCOORD4) : COLOR0
{

	float4 diffusemap = tex2D(b, tex);
	float2 lightTex = .5 * lightpos.xy/lightpos.w + float2(.5, .5f);
	lightTex.y = 1.f - lightTex.y;
	float4 spotmap = tex2D(a, lightTex);
	float4 shadow = tex2D(c, lightTex);

	float3 tnormal = tex2D(d, lightTex);
	tnormal.z = 1.f-tnormal.z;
	float3 realnormal = normalize(normal+tnormal);
	float diffuse = dot(normal, lightdir);
	float diffuse2 = dot(tnormal, lightdir);
	float halfdiff =  pow(diffuse2+.5f, 5);	

	float4 piss = tex2D(d, tt);

	return (diffusemap*diffuse)*spotmap*shadow * piss;//*tex2D(d, tt);
//	return (diffusemap*halfdiff)*spotmap*shadow;//*tex2D(d, tt);
}


technique Kube
{

	pass p2 //render4
	{
		VertexShader = compile vs_2_0 vs_kubegrid();
		PixelShader  = compile ps_2_0 ps_kubegrid3(); 
	}
}