float4x4 matWorldViewProjection;
float4x4 matView;
float4x4 matWorldView;
float4x4 matWorld;

float3 LigthPosition = {000.f, -100.f, 000.f};
float3 CameraPosition = {0.f, 100.f, 0.f};
texture tex0;  //a

float FogStart = 10.f;
float FogEnd = 180.f;

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
};


void vs_texture(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    in float3 inormal : NORMAL, 
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 ligthdir : TEXCOORD2,
			    out float depth : TEXCOORD3,
			    out float3 viewdir : TEXCOORD4)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
	onormal = normalize(mul(inormal, matWorldView));

//	onormal = mul(inormal, matView);
	
	float4 objspc = mul(ipos, matView);
	ligthdir = normalize(LigthPosition - objspc);
	viewdir = normalize(CameraPosition - objspc);
//	depth =  1.f-clamp((distance(mul(ipos.xyz, matWorld), CameraPosition)-FogStart) / (FogEnd-FogStart), 0.f, 1.f);
	depth = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}

float4 ps_texture(in float2 tex : TEXCOORD0,
				  in float3 normal : TEXCOORD1,
				  in float3 ligthdir : TEXCOORD2,
				  in float depth : TEXCOORD3) : COLOR0
{
	//return depth;
	float ndotl = dot(normal, ligthdir);
	return ndotl*tex2D(a, tex)*depth;
}

float4 ps_texture2(in float2 tex : TEXCOORD0,
				  in float3 normal : TEXCOORD1,
				  in float3 ligthdir : TEXCOORD2,
				  in float depth : TEXCOORD3,
				  in float3 viewdir : TEXCOORD4) : COLOR0
{
	float ndotl = abs(dot(normal, ligthdir));
	ndotl = max(ndotl, .4f);
	return tex2D(a, pow(dot(reflect(normal, ligthdir), viewdir), 18)*tex)*ndotl*(depth*1.6f);
}


technique Texture
{
	pass p0 //enviroment
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texture(); 
	}
	
	pass p1 //dorfs
	{
		VertexShader  = compile vs_2_0 vs_texture();
		PixelShader = compile ps_2_0 ps_texture2();
	}
}