float4x4 matWorldViewProjection; 
texture tex0;  //alpha

float2 point = {.2f, .2f};

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = Wrap;
	AddressV = Wrap;
};

void vs_texture(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    in float3 normal : NORMAL,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD,
			    out float3 diffuse : TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
	diffuse = clamp((float)distance(normal.xy, point)*2, 0, 1);
}

float4 ps_texture(in float2 tex : TEXCOORD0,
				  in float3 diffuse : TEXCOORD1) : COLOR0
{
	return float4(diffuse, 1.0);
	return tex2D(a, tex);
}

technique Texture
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texture(); 
	}
}