varying vec3 Vnormal;
varying vec3 pos;
varying vec3 view;
varying vec4 camn;

uniform sampler2D noiseTex;
uniform sampler2D texnorm;
uniform sampler2D texambient;
uniform sampler2D texbit;
uniform float time;

const vec3 bodycol = vec3(0.92, 0.85, 0.24);

void main() {
	vec3 lightDir = normalize(vec3(0.0, 0.0, 1.0));
//	lightDir = normalize((gl_ModelViewMatrixInverse*vec4(lightDir, 0.0)).xyz);

	vec2 xy = gl_TexCoord[0].xy;
	xy.y = -xy.y;

	vec3 tex = texture2D(texnorm, xy).rgb;
	vec3 normal = normalize(-1.0+2.0*tex);
	normal.z = -normal.z;

	normal = normalize((gl_ModelViewMatrixInverse*vec4(normal, 0.0)).xyz);

	float l1 = dot(normal, lightDir);
	float l2 = dot(normal, -lightDir);
	float l3 = dot(normal, vec3(0.0, 1.0, 0.0));
	float l4 = dot(normal, vec3(0.0, -1.0, 0.0));
	float light = max(l1, max(l2, max(l3, l4)));
	light *= 1.75;
	if (light < 0.25) light = 0.25;

	vec3 col = texture2D(texbit, 0.5+0.5*normal.xy).rgb;

	float amb = 2.0*texture2D(texambient, xy).r;

	gl_FragColor = vec4((light*amb*col*bodycol*0.4+0.2*col), 1.0);
}
